package com.sict.data.utils;

/**
 * @description 请求结果封装工具类
 *
 * @author Jxy
 * @date Create in 14:33 2019/10/17  
 */
public class ResponseUtil {

    /**
     * 请求成功
     */
    public static <T> MsgEnum success(T t, String msg) {
        MsgEnum msgEnum = MsgEnum.SUCCESS;
        msgEnum.setData(t);
        msgEnum.setMsg(msg);
        return msgEnum;
    }

    public static <T> MsgEnum success(T t) {
        MsgEnum msgEnum = MsgEnum.SUCCESS;
        msgEnum.setData(t);
        return msgEnum;
    }

    /**
     * 请求失败
     */
    public static <T> MsgEnum failure(T t, String msg) {
        MsgEnum msgEnum = MsgEnum.FAILURE;
        msgEnum.setData(t);
        msgEnum.setMsg(msg);
        return msgEnum;
    }

    public static MsgEnum failure(String msg) {
        MsgEnum msgEnum = MsgEnum.FAILURE;
        msgEnum.setMsg(msg);
        return msgEnum;
    }

    /**
     * 请求错误
     */
    public static <T> MsgEnum error(T t, String msg) {
        MsgEnum msgEnum = MsgEnum.ERROR;
        msgEnum.setData(t);
        msgEnum.setMsg(msg);
        return msgEnum;
    }

    public static MsgEnum error(String msg) {
        MsgEnum msgEnum = MsgEnum.ERROR;
        msgEnum.setMsg(msg);
        return msgEnum;
    }


}
