package com.sict.data.utils;

import com.alibaba.fastjson.annotation.JSONType;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * @description 0--请求错误/失败状态码；1--请求成功状态码
 *
 * @author Jxy
 * @date Create in 14:07 2019/10/17  
 */
// @JSONType(serializeEnumAsJavaBean = true)
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum MsgEnum {

    /**
     * 成功
     */
    SUCCESS(1,"请求成功"),
    /**
     * 失败
     */
    FAILURE(0,"请求失败"),
    /**
     * 错误
     */
    ERROR(-1,"请求错误");

    /**
     * 状态码
     */
    private int status;
    /**
     * 返回消息提示
     */
    private String msg;
    /**
     * 返回消息数据
     */
    private Object data;

    MsgEnum() {
    }

    MsgEnum(int status, String msg) {
        this.status = status;
        this.msg = msg;
    }

    MsgEnum(int status, String msg, Object data) {
        this.status = status;
        this.msg = msg;
        this.data = data;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public Object getData() {
        return data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    @Override
    public String toString() {
        return "MsgEnum{" +
            "status=" + status +
            ", msg='" + msg + '\'' +
            ", data=" + data +
            '}';
    }
}
