package com.sict.data.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.sict.data.dto.*;
import com.sict.data.model.DataPlat;

import java.util.List;

/**
 * @description 服务类
 *
 * @author Jxy
 * @date 2019-10-16
 */
public interface IDataPlatService extends IService<DataPlat> {

    /**
     * 获取各医联体下筛查人数排行榜（取前30个医联体） 接口 
     * @author Jxy
     * @return java.util.List<com.sict.data.dto.HospScreeningDTO>
     */
    List<HospScreeningDTO> getScreeningRank();

    /**
     * 获取血清检测人次统计结果（省份） 接口 
     * @author Jxy
     * @return com.sict.data.dto.SerumDTO
     */
    SerumDTO getSerumStatistics();

    /**
     * 获取胃镜检查人次统计结果（省份） 接口 
     * @author Jxy
     * @return com.sict.data.dto.GastroscopyDTO
     */
    GastroscopyDTO getGastroscopyStatistics();

    /**
     * 获取筛查人次统计结果（省份） 接口
     * @author Jxy
     * @return com.sict.data.dto.ScreeningDTO
     */
    ScreeningDTO getScreeningStatistics();

    /**
     * 获取胃镜精查最终诊断异常统计结果 接口
     * @author Jxy
     * @return java.lang.Object
     */
    GastroscopyResultDTO getGastroscopyDetailResultStatistics();

    /**
     * 获取患病风险等级评估统计 接口
     * @author Jxy
     * @return com.sict.data.dto.RiskAssessDTO
     */
    RiskAssessDTO getRiskAssessStatistics();

    /**
     * 获取胃镜精查统计结果 接口
     * @author Jxy
     * @return com.sict.data.dto.GastroscopyDetailDTO
     */
    GastroscopyDetailDTO getGastroscopyDetailStatistics();

    /**
     * 获取综合统计结果 接口
     * @author Jxy
     * @return com.sict.data.dto.ComplexResultDTO
     */
    ComplexResultDTO getComplexStatistics();

    /**
     * 获取医院相关统计（申请数、认证数、开展筛查数） 接口
     * @author Jxy
     * @return com.sict.data.dto.HospStatisticsDTO
     */
    HospStatisticsDTO getHospStatistics();
}
