package com.sict.data.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.sict.data.dto.*;
import com.sict.data.model.DataPlat;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * @description  Mapper 接口
 *
 * @author Jxy
 * @date 2019-10-16
 */
@Mapper
public interface DataPlatMapper extends BaseMapper<DataPlat> {

    /**
     * 获取各医联体下筛查人数排行榜（取前30个医联体）
     * @author Jxy
     * @return java.util.List<com.sict.data.dto.HospScreeningDTO>
     */
    List<HospScreeningDTO> getHospScreeningRank();

    /**
     * 获取各省份血清检测人次统计结果
     * @author Jxy
     * @return java.util.List<com.sict.data.dto.ProvinceSerumDTO>
     */
    List<ProvinceSerumDTO> getProvinceSerumStatistics();

    /**
     * 获取各省份胃镜检查人次统计结果
     * @author Jxy
     * @return java.util.List<com.sict.data.dto.ProvinceGastroscopyDTO>
     */
    List<ProvinceGastroscopyDTO> getProvinceGastroscopyStatistics();

    /**
     * 获取各省份筛查人次统计结果
     * @author Jxy
     * @return java.util.List<com.sict.data.dto.ProvinceScreeningDTO>
     */
    List<ProvinceScreeningDTO> getProvinceScreeningStatistics();

    /**
     * 获取省份胃镜精查最终诊断异常统计结果
     * @author Jxy
     * @return java.util.List<com.sict.data.dto.ProvinceGastroscopyResultDTO>
     */
    List<ProvinceGastroscopyResultDTO> getProvinceGastroscopyResult();

    /**
     * 获取患病风险等级评估统计
     * @author Jxy
     * @return com.sict.data.dto.RiskAssessDTO
     */
    RiskAssessDTO getRiskAssessStatistics();

    /**
     * 获取胃镜精查统计结果
     * @author Jxy
     * @return com.sict.data.dto.GastroscopyDetailDTO
     */
    GastroscopyDetailDTO getGastroscopyDetailStatistics();

    /**
     * 获取医院相关统计（申请数、认证数）
     * @author Jxy
     * @return com.sict.data.dto.HospStatisticsDTO
     */
    HospStatisticsDTO getHospStatistics();
}
