package com.sict.data.dto;

import lombok.Data;

import java.util.List;

/**
 * @description 血检结果统计
 *
 * @author Jxy
 * @date Create in 10:34 2019/10/18  
 */
@Data
public class SerumDTO {

    /**
     * 血检总人次
     */
    private Integer serumTestTotal;

    /**
     * 计划血检人次
     */
    private Integer serumTestPlan;

    /**
     * 实际血检人次
     */
    private Integer serumTestActual;

    /**
     * HP抗体（IGG）检测阳性总人次
     */
    private Integer iggPositive;

    /**
     * 早癌患者总数
     */
    private Integer earlyCancer;

    /**
     * 各省份血检结果统计集合
     */
    private List<ProvinceSerumDTO> dtoList;

}
