package com.sict.data.dto;

import lombok.Data;

/**
 * @description 省份胃镜精查最终诊断结果异常患者人次统计
 *
 * @author Jxy
 * @date Create in 15:36 2019/10/21  
 */
@Data
public class ProvinceGastroscopyResultDTO {

    /**
     * 省份名称
     */
    private String provinceName;

    /**
     * 省份诊断结果异常总人次
     */
    private Integer total;

    /**
     * 省份食管粘膜上皮内瘤变患者人次统计
     */
    private Integer esophagusTumor;

    /**
     * 省份早期食管癌患者人次统计
     */
    private Integer earlyEsophagealCancer;

    /**
     * 省份进展期食管癌患者人次统计
     */
    private Integer progressEsophagealCancer;

    /**
     * 省份Barret食管患者人次统计
     */
    private Integer barretEsophagus;

    /**
     * 省份反流性食管炎患者人次统计
     */
    private Integer refluxEsophagitis;

    /**
     * 省份胃粘膜上皮内瘤变患者人次统计
     */
    private Integer gastricMucosaTumor;

    /**
     * 省份早期胃癌患者人次统计
     */
    private Integer earlyGastricCancer;

    /**
     * 省份进展期胃癌患者人次统计
     */
    private Integer progressGastricCancer;

    /**
     * 省份萎缩性胃炎患者人次统计
     */
    private Integer atrophicGastritis;

    /**
     * 省份胃溃疡患者人次统计
     */
    private Integer stomachUlcer;

    /**
     * 省份胃息肉患者人次统计
     */
    private Integer gastricPolyp;

    /**
     * 省份非萎缩性胃炎患者人次统计
     */
    private Integer nonAtrophicGastritis;

    /**
     * 省份十二指肠球部溃疡患者人次统计
     */
    private Integer duodenalUlcer;

    /**
     * 省份其它病变患者人次统计
     */
    private Integer others;

    /**
     * 省份高级别上皮内瘤变患者人次统计
     */
    private Integer highEsophagusTumor;

}
