package com.sict.data.dto;

import lombok.Data;

import java.util.List;

/**
 * @description 胃镜精查最终诊断结果患者总人次统计
 *
 * @author Jxy
 * @date Create in 16:09 2019/10/21  
 */
@Data
public class GastroscopyResultDTO {

    /**
     * 诊断结果异常总人次
     */
    private Integer total;

    /**
     * 食管粘膜上皮内瘤变患者总人次统计
     */
    private Integer esophagusTumor;

    /**
     * 早期食管癌患者总人次统计
     */
    private Integer earlyEsophagealCancer;

    /**
     * 进展期食管癌患者总人次统计
     */
    private Integer progressEsophagealCancer;

    /**
     * Barret食管患者总人次统计
     */
    private Integer barretEsophagus;

    /**
     * 反流性食管炎患者总人次统计
     */
    private Integer refluxEsophagitis;

    /**
     * 胃粘膜上皮内瘤变患者总人次统计
     */
    private Integer gastricMucosaTumor;

    /**
     * 早期胃癌患者人次统计
     */
    private Integer earlyGastricCancer;

    /**
     * 进展期胃癌患者总人次统计
     */
    private Integer progressGastricCancer;

    /**
     * 萎缩性胃炎患者总人次统计
     */
    private Integer atrophicGastritis;

    /**
     * 胃溃疡患者总人次统计
     */
    private Integer stomachUlcer;

    /**
     * 胃息肉患者总人次统计
     */
    private Integer gastricPolyp;

    /**
     * 非萎缩性胃炎患者总人次统计
     */
    private Integer nonAtrophicGastritis;

    /**
     * 十二指肠球部溃疡患者总人次统计
     */
    private Integer duodenalUlcer;

    /**
     * 其它病变患者总人次统计
     */
    private Integer others;

    /**
     * 高级别上皮内瘤变患者总人次统计
     */
    private Integer highEsophagusTumor;

    /**
     * 省份胃镜精查最终诊断结果异常患者人次统计集合
     */
    private List<ProvinceGastroscopyResultDTO> dtoList;

}
