package com.sict.data.dto;

import lombok.Data;

/**
 * @description 综合统计结果
 *
 * @author Jxy
 * @date Create in 17:07 2019/10/25  
 */
@Data
public class ComplexResultDTO {

    /**
     * 血检总人次
     */
    private Integer serumActualTotal;

    /**
     * HP抗体（IGG）检测阳性总人次
     */
    private Integer iggPositive;

    /**
     * 应精查人次
     */
    private Integer gastroscopyDetailTotal;

    /**
     * 实际精查人次
     */
    private Integer gastroscopyDetailActual;

    /**
     * 高级别上皮内瘤变患者总人次统计
     */
    private Integer highEsophagusTumor;

    /**
     * 早期食管癌患者总人次统计
     */
    private Integer earlyEsophagealCancer;

    /**
     * 早期胃癌患者人次统计
     */
    private Integer earlyGastricCancer;

    /**
     * 萎缩性胃炎患者总人次统计
     */
    private Integer atrophicGastritis;

    /**
     * 胃溃疡患者总人次统计
     */
    private Integer stomachUlcer;

    /**
     * 胃息肉患者总人次统计
     */
    private Integer gastricPolyp;

    /**
     * 申请医院
     */
    private Integer applyHosp;

    /**
     * 认证医院
     */
    private Integer certifiedHosp;

    /**
     * 开展筛查医院
     */
    private Integer screeningHosp;

    /**
     * 筛查总人次统计
     */
    private Integer screeningTotal;

}
