package com.sict.data.controller;


import com.sict.data.utils.MsgEnum;
import com.sict.data.service.IDataPlatService;
import com.sict.data.utils.ResponseUtil;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description 前端控制器
 *
 * @author Jxy
 * @date 2019-10-16
 */
@AllArgsConstructor
@Slf4j
@RestController
@RequestMapping("/data-plat")
public class DataPlatController {

    private final IDataPlatService dataPlatService;

    /**
     * @description 获取各医联体下筛查人数排行榜（取前30个医联体）
     *
     * @author Jxy
     * @date 13:55 2019/10/17
     * @return com.sict.data.dto.ScreeningDTO
     */
    @GetMapping("/screening/rank")
    public MsgEnum getScreeningRank() {
        try {
            return ResponseUtil.success(dataPlatService.getScreeningRank());
        } catch (Exception e) {
            log.error("获取各医联体下筛查人数排行榜失败。错误信息：【{}】，错误详情：【{}】", e.toString(), e.getMessage());
            return ResponseUtil.error(e.toString(), "获取各医联体下筛查人数排行榜失败！");
        }
    }

    /**
     * @description 获取血清检测人次统计结果（省份）
     *
     * @author Jxy
     * @date 10:32 2019/10/18
     * @return com.sict.data.utils.MsgEnum
     */
    @GetMapping("/serum/statistics")
    public MsgEnum getSerumStatistics() {
        try {
            return ResponseUtil.success(dataPlatService.getSerumStatistics());
        } catch (Exception e) {
            log.error("获取省份血检人次统计结果失败。错误信息：【{}】，错误详情：【{}】", e.toString(), e.getMessage());
            return ResponseUtil.error(e.toString(), "获取省份血检人次统计结果失败！");
        }
    }

    
    /**
     * @description 获取胃镜检查人次统计结果（省份）
     *
     * @author Jxy
     * @date 14:22 2019/10/18
     * @return com.sict.data.utils.MsgEnum
     */
    @GetMapping("/gastroscopy/statistics")
    public MsgEnum getGastroscopyStatistics() {
        try {
            return ResponseUtil.success(dataPlatService.getGastroscopyStatistics());
        } catch (Exception e) {
            log.error("获取省份胃镜检查人次统计结果失败。错误信息：【{}】，错误详情：【{}】", e.toString(), e.getMessage());
            return ResponseUtil.error(e.toString(), "获取省份胃镜检查人次统计结果失败！");
        }
    }

    /**
     * @description 获取筛查人次统计结果（省份）
     *
     * @author Jxy
     * @date 11:20 2019/10/21
     * @return com.sict.data.utils.MsgEnum
     */
    @GetMapping("/screening/statistics")
    public MsgEnum getScreeningStatistics() {
        try {
            return ResponseUtil.success(dataPlatService.getScreeningStatistics());
        } catch (Exception e) {
            log.error("获取省份筛查人次统计结果失败。错误信息：【{}】，错误详情：【{}】", e.toString(), e.getMessage());
            return ResponseUtil.error(e.toString(), "获取省份筛查人次统计结果失败！");
        }
    }

    /**
     * @description 获取胃镜精查最终诊断异常统计结果
     *
     * @author Jxy
     * @date 13:50 2019/10/21
     * @return com.sict.data.utils.MsgEnum
     */
    @GetMapping("/result/statistics")
    public MsgEnum getGastroscopyDetailResultStatistics() {
        try {
            return ResponseUtil.success(dataPlatService.getGastroscopyDetailResultStatistics());
        } catch (Exception e) {
            log.error("获取胃镜精查最终诊断异常统计结果失败。错误信息：【{}】，错误详情：【{}】", e.toString(), e.getMessage());
            return ResponseUtil.error(e.toString(), "获取胃镜精查最终诊断异常统计结果失败！");
        }
    }

    /**
     * @description 获取患病风险等级评估统计
     *
     * @author Jxy
     * @date 16:24 2019/10/22
     * @return com.sict.data.utils.MsgEnum
     */
    @GetMapping("/risk/statistics")
    public MsgEnum getRiskAssessStatistics() {
        try {
            return ResponseUtil.success(dataPlatService.getRiskAssessStatistics());
        } catch (Exception e) {
            log.error("获取患病风险等级评估统计结果失败。错误信息：【{}】，错误详情：【{}】", e.toString(), e.getMessage());
            return ResponseUtil.error(e.toString(), "获取患病风险等级评估统计结果失败！");
        }
    }

    /**
     * @description 获取胃镜精查统计结果
     *
     * @author Jxy
     * @date 10:31 2019/10/23
     * @return com.sict.data.utils.MsgEnum
     */
    @GetMapping("/detail/statistics")
    public MsgEnum getGastroscopyDetailStatistics() {
        try {
            return ResponseUtil.success(dataPlatService.getGastroscopyDetailStatistics());
        } catch (Exception e) {
            log.error("获取胃镜精查统计结果失败。错误信息：【{}】，错误详情：【{}】", e.toString(), e.getMessage());
            return ResponseUtil.error(e.toString(), "获取胃镜精查统计结果失败！");
        }
    }

    /**
     * @description 获取综合统计结果
     *
     * @author Jxy
     * @date 17:05 2019/10/25
     * @return com.sict.data.utils.MsgEnum
     */
    @GetMapping("/complex/statistics")
    public MsgEnum getComplexStatistics() {
        try {
            return ResponseUtil.success(dataPlatService.getComplexStatistics());
        } catch (Exception e) {
            log.error("获取综合统计结果失败。错误信息：【{}】，错误详情：【{}】", e.toString(), e.getMessage());
            return ResponseUtil.error(e.toString(), "获取综合统计结果失败！");
        }
    }

    /**
     * @description 获取医院相关统计（申请数、认证数、开展筛查数）
     *
     * @author Jxy
     * @date 10:29 2019/10/28
     * @return com.sict.data.utils.MsgEnum
     */
    @GetMapping("/hosp/statistics")
    public MsgEnum getHospStatistics() {
        try {
            return ResponseUtil.success(dataPlatService.getHospStatistics());
        } catch (Exception e) {
            log.error("获取医院相关统计（申请数、认证数、开展筛查数）失败。错误信息：【{}】，错误详情：【{}】", e.toString(), e.getMessage());
            return ResponseUtil.error(e.toString(), "获取医院相关统计（申请数、认证数、开展筛查数）失败！");
        }
    }

}

