package com.sict.data.config;

import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/**
 * @description
 *
 * @author Jxy
 * @date Create in 15:57 2019/10/23  
 */
@Configuration
public class CorsFilterConfig {

    @Bean
    public FilterRegistrationBean<CorsFilter> corsFilter() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(true);
        ArrayList<String> objects = new ArrayList<>();
        objects.add("*");
        config.setAllowedOrigins(objects);
        config.setAllowedHeaders(objects);
        config.setAllowedMethods(objects);
        // source.registerCorsConfiguration("/**", config);
        Map<String, CorsConfiguration> corsConfigurations = new HashMap<>(1);
        corsConfigurations.put("/**", config);
        source.setCorsConfigurations(corsConfigurations);
        FilterRegistrationBean<CorsFilter> bean = new FilterRegistrationBean<>(new CorsFilter(source));
        bean.setOrder(0);
        return bean;
    }

}
