> 评估数据是否适合因子分析

因子分析（和主成分分析）的目标是通过识别和利用纳入分析的变量相关矩阵中的结构，在最小化信息损失的情况下降低数据维度。研究者通常会尝试将原始变量（或条目）与潜在因子关联，并为每个因子提供描述性标签。

### 示例：牙膏数据

首先，前往 “数据> 管理” 标签页，从 “加载数据类型（Load data of type）” 下拉菜单中选择**examples**，然后点击 “加载（Load）” 按钮。接着选择`toothpaste`数据集。该数据集包含 60 名消费者的信息，这些消费者被要求回答 6 个问题以确定他们对牙膏的态度。变量 v1-v6 所示的分数表示对陈述的同意程度，采用 7 分制，其中 1 = 强烈不同意，7 = 强烈同意。

因子分析的第一步是确定数据是否具有所需特征。变量间相关性有限或无相关性的数据不适合因子分析。我们将使用三个标准检验数据是否适合因子分析：巴特利特检验（Bartlett）、KMO 检验和每个变量的共线性。

KMO 检验和巴特利特检验共同评估所有可用数据。KMO 值大于 0.5 且巴特利特检验的显著性水平低于  0.05，表明数据中存在显著相关性。变量共线性表示单个变量与其他变量的相关强度，值大于 0.4 被认为是合适的。也可计算每个变量的 KMO  值，值大于 0.5 是可接受的。

从下方 “多元分析> 因子分析 > 预因子分析” 的输出中可以看出，巴特利特检验统计量大且显著（p 值接近 0），符合预期。凯泽 -  迈耶 - 奥尔金（KMO）度量大于 0.5，因此可接受。变量共线性值大于 0.4，且 KMO 值大于 0.5，因此所有变量均可用于分析。

要复现截图中的结果，请确保已加载`toothpaste`数据。然后选择变量`v1`至`v6`，点击 “估计（Estimate）” 按钮或按`CTRL-enter`（Mac 上为`CMD-enter`）生成结果。

<p align="center"><img src="figures_multivariate/pre_factor_summary.png"></p>

下一步是确定捕捉数据潜在结构所需的因子数量。通常会忽略那些捕捉的方差甚至不超过随机预期方差的因子，这些因子在输出中的特征值 < 1。

另一个常用于确定因子数量的标准是碎石图（scree-plot），它按提取顺序绘制特征值与因子数量的关系。图中通常会出现一个断点或 “拐点（elbow）”，如果拐点及之前的因子特征值均大于 1，则选择这些因子进行进一步分析。通常认为，解释原始数据 70%  以上方差的一组因子是可接受的。上方显示了所有因子的特征值，只有两个因子的特征值大于 1。

乍看之下，下方的特征值碎石图似乎表明应提取 3 个因子（即寻找 “拐点”）。条形图也证实了这一点，即因子 1 和因子 2 之间的特征值变化较小，但从因子 2 到因子 3 的下降幅度大得多。然而，由于第三个因子的特征值小于 1，我们将只提取 2 个因子。

<p align="center"><img src="figures_multivariate/pre_factor_plot.png"></p>

从 2 个因子增加到 3 个因子时，累积解释方差百分比的增幅相对较小（即从 82% 增至 90%）。因子 3 的特征值小于 1（0.44）也证实了这一点。因此，我们选择 2 个因子。前 2 个因子捕捉了原始数据 82% 的方差，这一结果非常好。

## 纳入分类变量

因子分析前置诊断通过主成分分析（PCA）计算。用于 PCA 的相关矩阵可基于`numeric`、`integer`、`date`和`factor`类型的变量计算。当纳入因子型变量时，应勾选 “调整分类变量（Adjust for categorical variables）” 框。进行调整后估计相关系数时，因子型变量将被视为（有序）分类变量，其他所有变量将被视为连续变量。

### 报告 > Rmd

通过点击屏幕左下角的<i title="report results" class="fa fa-edit"></i>图标或按键盘上的`ALT-enter`，向<a href="https://radiant-rstats.github.io/docs/data/report_rmd.html" target="_blank">*报告 > Rmd*</a>添加代码以（重新）创建分析。

如果已创建图表，可使用`ggplot2`命令或`gridExtra`进行自定义。详见下方示例和<a href="https://radiant-rstats.github.io/docs/data/visualize.html" target="_blank">*数据 > 可视化*</a>。

```r
plot(result, plots = "scree", custom = TRUE) + 
  labs(caption = "Data used from ...")
```

### R 函数

有关 Radiant 中用于进行因子分析的相关 R 函数概述，请参见<a href =  "https://radiant-rstats.github.io/radiant.multivariate/reference/index.html#section-multivariate-factor" target="_blank">*多元分析 > 因子分析*</a>。

`pre_factor`工具中使用的核心函数包括`stats`包中的`cor`、`base`包中的`eigen`，以及`psych`包中的`cortest.bartlett`和`KMO`。
