> 概率计算器

基于二项分布（Binomial）、卡方分布（Chi-squared）、离散分布（Discrete）、F 分布（F）、指数分布（Exponential）、正态分布（Normal）、泊松分布（Poisson）、t  分布（t）或均匀分布（Uniform）计算概率或数值。

## 电池测试

假设《消费者报告》（CR）想要测试制造商关于电池寿命的声明。制造商声称，超过 90% 的电池可为笔记本电脑提供至少 12 小时的连续使用电力。CR 为 20  台相同的笔记本电脑配备了该制造商的电池。如果制造商的声明准确，那么 15 台或更多笔记本电脑在 12 小时后仍能运行的概率是多少？

问题描述表明我们应从 “分布（Distribution）” 下拉菜单中选择 “二项分布（Binomial）”。要计算概率，选择 “数值（Values）” 作为 “输入类型（Input type）”，并输入`15`作为 “上限（Upper bound）”。在下方输出中，我们可以看到该概率为 0.989。恰好 15 台笔记本电脑在 12 小时后仍能运行的概率为 0.032。

<p align="center"><img src="figures_basics/prob_calc_batteries.png"></p>

## 耳机需求

制造商希望确定耳机的适当库存水平，以实现 95% 的<a href="https://en.wikipedia.org/wiki/Service_level"  target="_blank">服务水平</a>。耳机需求服从均值为 3000、标准差为 800 的正态分布。

要找到所需持有的耳机库存数量，从 “分布（Distribution）” 下拉菜单中选择 “正态分布（Normal）”，然后选择 “概率（Probability）” 作为 “输入类型（Input type）”。输入`.95`作为 “上限（Upper bound）”。在下方输出中，我们看到应备货的数量为 4316 台。

<p align="center"><img src="figures_basics/prob_calc_headphones.png"></p>

## 冰淇淋杯数

**离散**随机变量只能取有限个可能的值。离散随机变量的**概率分布**列出了这些值及其概率。例如，顾客购买冰淇淋杯数的概率分布可描述如下：

* 40% 的顾客购买 1 杯；
* 30% 的顾客购买 2 杯；
* 20% 的顾客购买 3 杯；
* 10% 的顾客购买 4 杯。

我们可以使用随机变量的概率分布计算其**均值**（或**期望价值**）：

$$
  E(C) = \mu_C = 1 \times 0.40 + 2 \times 0.30 + 3 \times 0.20 + 4 \times 0.10 = 2\,,
$$

其中μC是购买杯数的均值。我们可以**预期**随机选择的顾客会购买 2 杯。方差计算如下：

$$
  Var(C) = (1 - 2)^2 \times 0.4 + (2 - 2)^2 \times 0.3 + (3 - 2)^2 \times 0.2 + (4 - 2)^2 \times 0.1 = 1\,.
$$

要获取上述离散概率分布的均值和标准差，以及顾客购买 2 杯或更多杯的概率（0.6），在概率计算器中进行如下设置。

<p align="center"><img src="figures_basics/prob_calc_icecream.png"></p>

## 假设检验

你也可以使用概率计算器确定统计检验的`p值（p.value）`或`临界值（critical value）`。详见 “基础（Basics）” 菜单中 “单样本均值（Single mean）”、“单样本比例（Single  proportion）”、“均值比较（Compare means）”、“比例比较（Compare  proportions）”、“交叉表（Cross-tabs）” 以及 “模型（Model）” 菜单中 “线性回归（OLS）” 的帮助文件。

### 报告 > Rmd

通过点击屏幕左下角的<i title="report results" class="fa fa-edit"></i>图标或按键盘上的`ALT-enter`，向<a href="https://radiant-rstats.github.io/docs/data/report_rmd.html" target="_blank">*报告 > Rmd*</a>添加代码以（重新）创建分析。

如果已创建图表，可使用`ggplot2`命令进行自定义（例如，`plot(result) + labs(title = "正态分布")`）。详情请参见<a href="https://radiant-rstats.github.io/docs/data/visualize.html" target="_blank">*数据 > 可视化*</a>。

### R 函数

有关 Radiant 中用于概率计算的相关 R 函数概述，请参见<a href =  "https://radiant-rstats.github.io/radiant.basics/reference/index.html#section-basics-probability" target="_blank">*基础 > 概率*</a>。

概率计算器中使用的来自`stats`包的核心函数：

* `prob_norm`使用`pnorm`、`qnorm`和`dnorm`
* `prob_lnorm`使用`plnorm`、`qlnorm`和`dlnorm`
* `prob_tdist`使用`pt`、`qt`和`dt`
* `prob_fdist`使用`pf`、`qf`和`df`
* `prob_chisq`使用`pchisq`、`qchisq`和`dchisq`
* `prob_unif`使用`punif`、`qunif`和`dunif`
* `prob_binom`使用`pbinom`、`qbinom`和`dbinom`
* `prob_expo`使用`pexp`、`qexp`和`dexp`
* `prob_pois`使用`ppois`、`qpois`和`dpois`

### 视频教程

将以下完整命令复制粘贴到 RStudio 控制台（即左下角窗口），按回车即可获取 Radiant 教程系列中概率计算器模块使用的所有材料：

<pre>usethis::use_course("https://www.dropbox.com/sh/zw1yuiw8hvs47uc/AABPo1BncYv_i2eZfHQ7dgwCa?dl=1")</pre>

<a href="https://youtu.be/UPL_8ujAXpww" target="_blank">描述离散随机变量的分布（一）</a>

- 本视频展示如何使用 Radiant 中的概率计算器汇总离散随机变量的信息
- 主题列表：
  - 手动计算离散随机变量的均值和方差
  - 在 Radiant 中计算离散随机变量的均值、方差和特定概率

<a href="https://youtu.be/30YsxCTbDTc" target="_blank">在 Radiant 中描述正态分布和二项分布（二）</a>

- 本视频展示如何使用 Radiant 中的概率计算器汇总正态分布和二项分布的信息
- 主题列表：
  - 在 Radiant 中计算服从正态分布的随机变量的概率
  - 手动计算服从二项分布的随机变量的概率
  - 在 Radiant 中计算服从二项分布的随机变量的概率

<a href="https://youtu.be/LbwUpEwTJ_Q" target="_blank">在 Radiant 中描述均匀分布和二项分布（三）</a>

- 本视频展示如何使用 Radiant 中的概率计算器汇总均匀分布和二项分布的信息
- 主题列表：
  - 在 Radiant 中计算服从均匀分布的随机变量的概率
  - 在 Radiant 中计算服从二项分布的随机变量的概率

<a href="https://youtu.be/XC2yN5BY8jg" target="_blank">设置概率边界（四）</a>

- 本视频演示如何在 Radiant 中设置概率边界
- 主题列表：
  - 使用概率作为输入类型
  - 对临界值向上取整
