> 拟合优度检验用于确定样本数据是否与假设的分布一致

### 示例

数据来自 580 名报纸读者的样本，这些读者表明了（1）他们最常阅读的报纸（《今日美国》或《华尔街日报》）和（2）他们的收入水平（低收入 vs.  高收入）。数据包含三个变量：受访者标识符（id）、受访者收入（高或低）以及受访者主要阅读的报纸（《今日美国》或《华尔街日报》）。

收集这些数据是为了研究收入水平与报纸选择之间是否存在关系。为确保结果具有可推广性，样本必须能代表目标总体。已知在该总体中，《今日美国》读者的相对比例高于《华尔街日报》读者，两者比例分别应为 55% 和 45%。我们可以使用拟合优度检验来检验以下原假设和备择假设：

- H0：《今日美国》和《华尔街日报》的阅读份额分别为 55% 和 45%
- Ha：《今日美国》和《华尔街日报》的阅读份额不等于上述设定值

如果基于可用样本不能拒绝原假设，则观察数据与假设的总体份额或概率之间存在 “良好拟合”。在 Radiant（基础 > 表格 >  拟合优度检验）中，选择 “报纸（Newspaper）” 作为分类变量。如果我们将 “概率（Probabilities）” 输入框留空（或输入  1/2），则会检验份额是否相等。但为了检验 H0 和 Ha，我们需要输入`0.45 and 0.55`，然后按回车键。首先，比较观察频数和期望频数。期望频数基于原假设成立（即与设定份额无偏差）计算，公式为总样本量 ×p，其中 p 是某个单元格的假设份额（或概率）。

<p align="center"><img src="figures_basics/goodness_summary.png"></p>

（皮尔逊）卡方检验用于评估我们是否可以拒绝观察值与期望值一致的原假设。它通过比较观察频数（即数据中实际看到的频数）与期望频数（即如果份额分布与我们假设的一致时预期看到的频数）来实现。如果期望频数表与观察频数表之间存在较大差异，卡方值将**较大**。每个单元格的卡方值计算公式为`(o - e)^2 / e`，其中`o`是单元格中的观察频数，`e`是原假设成立时该单元格的期望频数。点击 “卡方（Chi-squared）” 复选框可显示这些值。总卡方值通过对所有单元格求和获得，即它是 “卡方贡献（Contribution to chi-square）” 表中所示值的总和。

为了确定卡方统计量是否可被视为**较大**，我们首先计算自由度（df = 单元格数量 - 1）。在包含两个单元格的表格中，自由度 =（2-1）=1。“摘要（Summary）” 标签页的输出显示了卡方统计量的值、自由度以及检验的 p 值。我们还能看到每个单元格对总卡方统计量的贡献。

记住要检查期望値：所有期望频数均大于 5，因此卡方统计量的 p 值不太可能存在偏差（另见下方技术说明）。与通常一样，当 p 值小于 0.05 时，我们拒绝原假设。由于我们的 p  值非常大（>0.8），我们不能拒绝原假设（即观察数据中的份额分布与我们假设的一致）。

我们可以使用与 0.028 的卡方值相关的 p 值来评估原假设。不过，我们也可以使用概率计算器计算临界卡方值。从下方输出中可以看到，如果选择 95%  的置信水平，临界值为 3.841。由于计算得到的卡方值小于临界值（0.028 < 3.841），我们不能拒绝上述原假设。

<p align="center"><img src="figures_basics/compare_props_prob_calc.png"></p>

我们也可以使用概率计算器确定与计算得到的卡方值相关的 p 值。与 “摘要” 标签页的输出一致，该`p.value`为`< .001`。

<p align="center"><img src="figures_basics/goodness_chi_pvalue.png"></p>

除 “摘要” 标签页中的数值输出外，我们还可以在 “绘图（Plot）” 标签页中可视化评估假设。

### 报告 > Rmd

通过点击屏幕左下角的<i title="report results" class="fa fa-edit"></i>图标或按键盘上的`ALT-enter`，向<a href="https://radiant-rstats.github.io/docs/data/report_rmd.html" target="_blank">*报告 > Rmd*</a>添加代码以（重新）创建分析。

如果已创建图表，可使用`ggplot2`命令进行自定义（例如，`plot(result, check = "observed", custom = TRUE) + labs(y = "百分比")`）。详情请参见<a href="https://radiant-rstats.github.io/docs/data/visualize.html" target="_blank">*数据 > 可视化*</a>。

### 技术说明

当一个或多个期望値较小时（例如≤5），卡方检验的 p 值通过模拟方法计算。如果某些单元格的期望计数低于 1，可能需要合并单元格 / 类别。

### R 函数

有关 Radiant 中用于评估离散概率分布的相关 R 函数概述，请参见<a href =  "https://radiant-rstats.github.io/radiant.basics/reference/index.html#section-basics-tables" target="_blank">*基础 > 表格*</a>。

`goodness`工具中使用的来自`stats`包的核心函数是`chisq.test`。
