> 将单个比例与总体比例进行比较

单样本比例检验（或单样本二项检验）用于将样本数据中某类响应或取值的比例与我们样本数据所来自的总体中的（假设）比例进行比较。这很重要，因为我们很少能获取整个总体的数据。“比较值（Comparison value）” 框中指定了总体中的假设值。

我们可以执行单侧检验（即`小于`或`大于`）或双侧检验（见 “备择假设（Alternative hypothesis）” 下拉菜单）。单侧检验用于评估现有数据是否提供证据表明样本比例大于（或小于）比较值（即原假设中的总体值）。

## 示例

一家汽车制造商通过在新目标市场随机抽样并采访 1000 名消费者开展了一项研究。研究目标是确定消费者是否会考虑购买该品牌汽车。

管理层已决定公司将进入该细分市场。但如果品牌偏好率低于 10%，将投入额外资源用于广告和赞助，以提高目标消费者中的品牌知名度。在样本中，有 93 名消费者表现出公司所认为的强烈品牌喜爱度。

你可以在**consider.rda**数据集中找到调查参与者的响应信息。该数据集包含两个变量：`id`和`consider`。

我们的原假设是，会考虑在未来购买该汽车品牌的消费者比例等于 10%。从 “变量（Variable）” 下拉菜单中选择`consider`变量。要评估样本中`yes`响应的比例，从 “选择水平（Choose level）” 下拉菜单中选择`yes`。

从 “备择假设（Alternative hypothesis）” 下拉菜单中选择 “小于（Less than）” 选项，以确定现有数据是否提供足够证据拒绝原假设，支持 “会考虑该品牌的消费者比例**小于 10%**” 的备择假设。

<p align="center"><img src="figures_basics/single_prop_summary.png"></p>

输出的前两个区块显示检验的基本信息（如原假设和备择假设）和汇总统计量（如 “yes” 响应的比例、标准误、误差边际等）。输出的最后一行显示以下内容：

- `diff`是样本比例（0.093）与比较值（0.1）之间的差值
- `ns`是成功次数。这是我们可以与参数为n=1000和p=0.10的二项分布进行比较的数量
- `p.value`是在原假设为真时，找到与`diff`一样极端或更极端值的概率
- `0% 95%`显示样本比例的 95% 置信区间（0 至 0.11）。这些数值提供了真实总体比例可能落入的范围

### 检验方法

我们可以使用三种方法评估原假设。我们选择显著性水平为 0.05。<sup>1</sup> 当然，每种方法会得出相同结论。

#### p 值

由于 p 值**大于**常规显著性水平（0.249>0.05），我们**不能**拒绝原假设，且**不建议**管理层投入资源提高品牌知名度。

我们也可以通过 “基础（Basics）” 菜单中的概率计算器获取 p 值。在参数为n=1000和p=0.1的二项分布中，输入数据中的成功次数（93）作为下界（值）。p 值是观察到与样本中 93 次成功一样极端或更极端的成功次数的概率。我们看到P(X<=93)=0.249，这与 “基础> 比例 > 单样本比例” 中的结果相同。

<p align="center"><img src="figures_basics/single_prop_prob_calc_v.png"></p>

#### 置信区间

由于 “比较值”**包含在**置信区间内（即0<0.1<0.11），我们**不能**拒绝原假设，且**不建议**管理层投入资源提高品牌知名度。

#### 成功次数

我们可以通过 “基础（Basics）” 菜单中的概率计算器获取临界值。对于参数为n=1000和p=0.1的二项分布，临界值为 85。由于备择假设是 “小于（Less than）”，我们必须输入 0.05 作为下侧概率界。<sup>2</sup>

<p align="center"><img src="figures_basics/single_prop_prob_calc_p.png"></p>

由于成功次数（即 “yes” 响应的数量）**大于**临界值（93 vs 85），我们**不能**拒绝原假设，且**不建议**管理层投入资源提高品牌知名度。

### 统计术语

这是**单样本比例**检验，原假设为真实总体**比例**等于**0.1**。使用 0.05 的显著性水平，我们**不能**拒绝原假设，且**不能**得出真实总体**比例** **小于**0.1 的结论。

该检验的 p 值为**0.249**。这是在原假设为真时，观察到与从数据中估计的样本**比例**（或**成功次数**）一样极端或更极端的样本值的概率。在本例中，它是当真实总体**比例**为**0.1**时，观察到样本**比例**（**成功次数**）小于（或等于）**0.093**（**93**）的概率。

95% 置信界为**0.11**。如果重复抽样并为每个样本计算 95% 置信界，真实总体比例将在 95% 的样本中低于该界值。

<sup>1</sup>**显著性水平**（通常用α表示）是你愿意接受的、在原假设实际为真时拒绝原假设的最高概率。常用的显著性水平为 0.05（或 5%）。

<sup>2</sup> 1−α称为**置信水平**。常用的置信水平为 0.95（或 95%）。

### 报告 > Rmd

通过点击屏幕左下角的<i title="report results" class="fa fa-edit"></i>图标或按键盘上的`ALT-enter`，向<a href="https://radiant-rstats.github.io/docs/data/report_rmd.html" target="_blank">*报告 > Rmd*</a>添加代码以（重新）创建分析。

如果已创建图表，可使用`ggplot2`命令进行自定义（例如，`plot(result, plots = "bar", custom = TRUE) + labs(y = "百分比")`）。详情请参见<a href="https://radiant-rstats.github.io/docs/data/visualize.html" target="_blank">*数据 > 可视化*</a>。

### R 函数

有关 Radiant 中用于评估比例的相关 R 函数概述，请参见<a href =  "https://radiant-rstats.github.io/radiant.basics/reference/index.html#section-basics-proportions" target="_blank">*基础 > 比例*</a>。

`single_prop`工具中使用的来自`stats`包的核心函数是`binom.test`和`prop.test`。

### 视频教程

将以下完整命令复制粘贴到 RStudio 控制台（即左下角窗口），按回车即可获取 Radiant 教程系列中假设检验模块使用的所有材料：

<pre>usethis::use_course("https://www.dropbox.com/sh/0xvhyolgcvox685/AADSppNSIocrJS-BqZXhD1Kna?dl=1")</pre>

<a href="https://youtu.be/tTYvBUCaR3w" target="_blank">单样本比例假设检验</a>

- 本视频展示如何检验关于单样本比例与总体比例的假设
- 主题列表：
  - 在 Radiant 中设置单样本比例的假设检验
  - 使用 p 值、置信区间或临界值评估假设检验
