> 将单个均值与总体均值进行比较

单样本均值 t 检验（或单样本 t 检验）用于将样本数据中某个变量的均值与我们样本数据所来自的总体中的（假设）均值进行比较。这很重要，因为我们很少能获取整个总体的数据。“比较值（Comparison value）” 框中指定了总体中的假设值。

我们可以执行单侧检验（即`小于`或`大于`）或双侧检验（见 “备择假设（Alternative hypothesis）” 下拉菜单）。单侧检验用于评估现有数据是否提供证据表明样本均值大于（或小于）比较值（即原假设中的总体值）。

## 示例

我们获取了英国杂货店随机样本的数据。如果该产品类别的消费者需求超过 1 亿单位（即每家店约 1750 单位），管理层将考虑进入该市场。样本中每家店的平均需求为 1953 单位。虽然这个数字大于 1750，但我们需要确定这种差异是否可能由抽样误差导致。

你可以在**demand_uk.rda**数据集中找到各样本店的单位销售量信息。该数据集包含两个变量：`store_id`（店铺 ID）和`demand_uk`（英国需求）。我们的原假设是英国每家店的平均需求等于 1750 单位，因此将该数值输入 “比较值（Comparison value）” 框。我们从 “备择假设（Alternative  hypothesis）” 下拉菜单中选择 “大于（Greater than）”  选项，因为我们想确定现有数据是否提供足够证据拒绝原假设，支持英国每家店的平均需求**大于 1750 单位**的备择假设。

<p align="center"><img src="figures_basics/single_mean_summary.png"></p>

输出的前两个区块显示检验的基本信息（如原假设和备择假设）和汇总统计量（如均值、标准差、标准误、误差边际等）。输出的最后一行显示以下内容：

- `diff`是样本均值（1953.393）与比较值（1750）之间的差值
- `se`是标准误（即`diff`抽样分布的标准差）
- `t.value`是与`diff`相关的 t 统计量，可与 t 分布比较（即`diff` / `se`）
- `p.value`是在原假设为真时，找到与`diff`一样极端或更极端值的概率
- `df`是统计检验的自由度（即 n - 1）
- `5% 100%`显示样本均值的 95% 置信区间（1897 至无穷大）。这些数值提供了真实总体均值可能落入的范围

### 检验方法

我们可以使用三种方法评估原假设。我们选择显著性水平为 0.05。<sup>1</sup> 当然，每种方法会得出相同结论。

#### p 值

由于 p 值**小于**常规显著性水平（即 0.05），我们拒绝原假设，并建议管理层应进入英国市场。注意，“***” 用作显著性指标。

#### 置信区间

由于 “比较值”**未**包含在置信区间内，我们拒绝原假设，并建议管理层应进入英国市场。

#### t 值

由于计算的 t 值（5.967）**大于**临界 t 值，我们拒绝原假设，并建议管理层应进入英国市场。可通过 “基础（Basics）” 菜单中的概率计算器获取临界 t 值。对于自由度为 571 的 t 分布（见`df`），临界 t 值为 1.648。由于备择假设是 “大于（Greater than）”，我们必须输入 0.95 作为上侧概率界（即 1 - 0.05）。<sup>2</sup>

<p align="center"><img src="figures_basics/single_mean_prob_calc.png"></p>

除 “摘要（Summary）” 标签页中的数值输出外，我们还可以在 “绘图（Plot）” 标签页中可视化数据。侧边栏中的设置与之前相同。直方图中的黑线显示样本均值（实线）和样本均值的置信区间（虚线）。红线显示比较值（即原假设下的单位销售量）。由于红线**未**落在置信区间（1897 至无穷大）内，我们拒绝原假设，接受备择假设。

<p align="center"><img src="figures_basics/single_mean_plot.png"></p>

### 统计术语

这是**单样本均值**检验，原假设为真实总体**均值**等于**1750**。使用 0.05 的显著性水平，我们拒绝原假设，并得出结论：真实总体**均值** **大于**1750。

该检验的 p 值为 **< .001**。这是在原假设为真时，观察到与数据中样本**均值**一样极端或更极端的样本**均值**的概率。在本例中，它是当真实总体**均值**为**1750**时，观察到样本**均值**大于（或等于）**1953.393**的概率。

5% 置信界为**1897.233**。如果重复抽样并为每个样本计算 5% 置信界，真实总体均值将在 95% 的样本中超过该下界。

<sup>1</sup>**显著性水平**（通常用α表示）是你愿意接受的、在原假设实际为真时拒绝原假设的最高概率。常用的显著性水平为 0.05（或 5%）。

<sup>2</sup> 1−α称为**置信水平**。常用的置信水平为 0.95（或 95%）。

### 报告 > Rmd

通过点击屏幕左下角的<i title="report results" class="fa fa-edit"></i>图标或按键盘上的`ALT-enter`，向<a href="https://radiant-rstats.github.io/docs/data/report_rmd.html" target="_blank">*报告 > Rmd*</a>添加代码以（重新）创建分析。

如果已创建图表，可使用`ggplot2`命令进行自定义（例如，`plot(result, plots = "hist", custom = TRUE) + labs(title = "直方图")`）。详情请参见<a href="https://radiant-rstats.github.io/docs/data/visualize.html" target="_blank">*数据 > 可视化*</a>。

### R 函数

有关 Radiant 中用于评估均值的相关 R 函数概述，请参见<a href =  "https://radiant-rstats.github.io/radiant.basics/reference/index.html#section-basics-means" target="_blank">*基础 > 均值*</a>。

`single_mean`工具中使用的来自`stats`包的核心函数是`t.test`。

### 视频教程

将以下完整命令复制粘贴到 RStudio 控制台（即左下角窗口），按回车即可获取 Radiant 教程系列中假设检验模块使用的所有材料：

<pre>usethis::use_course("https://www.dropbox.com/sh/0xvhyolgcvox685/AADSppNSIocrJS-BqZXhD1Kna?dl=1")</pre>

<a href="https://youtu.be/QV1qA5RPzlY" target="_blank">单样本均值假设检验</a>

- 本视频展示如何检验关于单样本均值与总体均值的假设
- 主题列表：
  - 计算样本的汇总统计量
  - 在 Radiant 中设置单样本均值的假设检验
  - 使用 p 值、置信区间或临界值评估假设检验
