help_quickgen <- c(
  "一键生成描述性统计" = "quickgen_basic.md", 
  "大模型对话引导助手" = "quickgen_chat.md",
  "大模型生成描述性统计" = "quickgen_ai.md"
)
output$help_quickgen <- reactive(append_help("help_quickgen", file.path(getOption("radiant.path.quickgen"), "app/tools/help"), Rmd = TRUE))

observeEvent(input$help_quickgen_all, {
  help_switch(input$help_quickgen_all, "help_quickgen")
})
observeEvent(input$help_quickgen_none, {
  help_switch(input$help_quickgen_none, "help_quickgen", help_on = FALSE)
})

help_quickgen_panel <- tagList(
  wellPanel(
    HTML("<label>一键生成菜单: <i id='help_quickgen_all' title='全选' href='#' class='action-button glyphicon glyphicon-ok'></i>
    <i id='help_quickgen_none' title='取消全选' href='#' class='action-button glyphicon glyphicon-remove'></i></label>"),
    checkboxGroupInput(
      "help_quickgen", NULL, help_quickgen,
      selected = state_group("help_quickgen"), inline = TRUE
    )
  )
)