> 使用 R 创建（可重复的）报告

“报告> R” 标签页允许你运行 R 代码，且可访问 Radiant 中的所有函数和数据。点击`编译报告（R）`按钮后，代码将被执行，输出结果会显示在 “报告> R” 页面的右侧。要仅执行部分代码，用光标选中该部分并按`CTRL-enter`（Mac 上为`CMD-enter`）。

你可以通过点击 “加载报告（Load report）” 按钮并选择.r 或.R 文件，将 R 代码文件加载到 Radiant 中。如果你从 RStudio  启动 Radiant，可以通过从下拉菜单中选择所需格式并点击 “保存报告（Save report）” 按钮，将报告保存为 HTML、Word 或 PDF 格式。要仅保存代码，从下拉菜单中选择`R`并按 “保存报告” 按钮。

如果你从 RStudio 启动 Radiant，还可以点击 “读取文件（Read files）” 按钮浏览文件并生成将其读入 Radiant  的代码。例如，读取 rda、rds、xls、yaml 和 feather 格式的文件，并将它们添加到 “数据集（Datasets）”  下拉菜单中。如果你想要加载的文件类型当前不支持，将返回文件路径。使用的文件路径将相对于 RStudio 项目根目录。同步到本地 Dropbox 或 Google Drive 文件夹的文件路径将使用`find_dropbox`和`find_gdrive`函数，以增强可重复性。

例如，你可以将下方代码复制粘贴到编辑器中，然后按`Knit report (R)`生成结果。

```r
## get the active dataset and show the first few observations
.get_data() %>%
  head()

## access a dataset
diamonds %>%
  select(price, clarity) %>%
  head()

## add a variable to the diamonds data
diamonds <- mutate(diamonds, log_price = log(price))

## show the first observations in the price and log_price columns
diamonds %>%
  select(price, log_price) %>%
  head()

## create a histogram of prices
diamonds %>%
  ggplot(aes(x = price)) +
    geom_histogram()

## and a histogram of log-prices using radiant.data::visualize
visualize(diamonds, xvar = "log_price", custom = TRUE)

## open help in the R-studio viewer from Radiant
help(package = "radiant.data")

## If you are familiar with Shiny you can call reactives when the code
## is evaluated inside a Shiny app. For example, if you transformed
## some variables in Data > Transform you can call the transform_main
## reacive to see the latest result. Very useful for debugging
# transform_main() %>% head()
head()
```

## 选项

“报告> Rmd” 和 “报告 > R” 中使用的编辑器有多个选项可在`.Rprofile`中设置。

```r
options(radiant.ace_vim.keys = FALSE)
options(radiant.ace_theme = "cobalt")
options(radiant.ace_tabSize = 2)
options(radiant.ace_useSoftTabs = TRUE)
options(radiant.ace_showInvisibles = TRUE)
options(radiant.ace_autoComplete = "live")
```

说明：

- `vim.keys`启用一组特殊的键盘快捷键。如果你从未使用过 VIM，可能不需要开启此选项
- 有关可用的编辑器主题概述，参见：`shinyAce::getAceThemes()`
- 默认情况下，制表符会转换为 2 个空格（即 “软” 制表符）。你可以将使用的空格数从 2 更改为例如 4
- `showInvisibles`在编辑器中显示制表符和空格
- 自动完成有 “live”“enabled” 和 “disabled” 三个选项

### R 函数

有关 Radiant 中用于生成可重复报告的相关 R 函数概述，请参见<a href = "  https://radiant-rstats.github.io/radiant.data/reference/index.html#section-data-report" target="_blank">*报告*</a> 。
