> 评估回归模型性能

要将表格下载为 csv 文件，点击屏幕右侧的顶部下载按钮。要将图表下载为 png 文件，点击屏幕右侧的下方下载图标。

#### 响应变量（Response variable）

关注的数值型结果变量或响应变量。

#### 预测变量（Predictor）

选择一个或多个可用于预测响应变量值的变量。可以是普通变量或模型的预测值（例如，通过 “模型> 线性回归（OLS）” 估计的回归模型，或通过 “模型 > 神经网络” 估计的神经网络模型的预测值）。

#### 结果显示范围（Show results for）

如果启用了筛选器（例如，在 “数据> 查看” 标签页中设置），可生成 “全部（All）” 数据、“训练（Training）” 数据、“测试（Test）” 数据或 “训练和测试（Both）” 数据的结果。若未启用筛选器，计算将应用于所有数据。

## 示例

预测值来自对`diamonds`数据集的线性回归和隐藏层含两个节点的神经网络。在估计之前，对`price`和`carat`变量进行了对数转换。该数据集可通过 “数据> 管理” 标签页获取（即从 “加载数据类型（Load data of type）” 下拉菜单中选择  “示例（Examples）”，然后点击 “加载（Load）”）。下方显示的预测值在 “预测（Predict）” 标签页中生成。

<p align="center"><img src="figures_model/evalreg_nn.png"></p>

测试统计量显示神经网络（NN）有微小但稳定的优势。

<p align="center"><img src="figures_model/evalreg_summary_plot.png"></p>

### Report > Rmd

通过点击屏幕左下角的<i title="report results" class="fa fa-edit"></i>图标或按键盘上的`ALT-enter`，向<a href="https://radiant-rstats.github.io/docs/data/report_rmd.html" target="_blank">*Report> Rmd*</a>添加代码以（重新）创建分析。

默认情况下会绘制`R平方（Rsq）`、`均方根误差（RSME）`和`平均绝对误差（MAE）`。可通过 “报告> Rmd” 自定义绘制结果。例如，要更改绘图，可使用：

```r
plot(result, vars = "Rsq")
```

图表可使用`ggplot2`命令进一步自定义（见下方示例）。详情请参见<a href="https://radiant-rstats.github.io/docs/data/visualize.html" target="_blank">*数据 > 可视化*</a>。

```r
plot(result, vars = "Rsq") +
  labs(caption = "Based on data from ...")
```

### R 函数（R-functions）

有关 Radiant 中用于评估回归模型的相关 R 函数概述，请参见<a href =  "https://radiant-rstats.github.io/radiant.model/reference/index.html#section-model-evaluate-regression" target="_blank">*模型 > 回归模型评估*</a> 。