> 随机分配受访者到实验条件

使用随机分配工具时，需选择数据集中每行均唯一（即无重复）的数据集。Radiant 中捆绑了一个符合此要求的数据集，可通过 “数据> 管理” 标签页获取（即从 “加载数据类型” 下拉菜单中选择`Examples`，然后点击 “加载”）。从 “数据集” 下拉菜单中选择`rndnames`。

`Names`是该数据集中的唯一标识符。如果我们选择这个变量并指定两个（或更多）“条件（Conditions）”（例如 “test（测试）” 和 “control（对照）”），将显示一个表格，其中包含`.conditions`列，表明每个人被（随机）分配到哪个条件。

默认情况下，“随机分配” 工具会为每个条件使用相等的概率。但如下方截图所示，也可以指定分配概率（例如 30% 分配到 “test”，70% 分配到 “control” 条件）。

<p align="center"><img src="figures_design/randomizer.png"></p>

如果我们预期某些变量可能预测实验结果，则可以使用 “区组化（blocking）” 来减少抽样变异。在区组随机分配（或分层随机分配）中，受试者首先根据一个或多个特征被分为不同区组（或层），然后在每个区组内进行随机分配。例如，如果我们选择`Gender`作为 “区组变量（Blocking variable）”，“随机分配” 工具将根据我们预先指定的 “概率（Probabilities）”，尝试将恰好 30% 的男性和恰好 30% 的女性分配到处理条件。如下方截图所示，男性和女性到测试组和对照组的分配结果完全符合预期。

<p align="center"><img src="figures_design/randomizer_block.png"></p>

默认情况下，随机种子设为`1234`，以确保抽样结果可重复。如果 “随机种子（Rnd. seed）” 输入框为空，每次生成样本时所选行都会变化。

要下载包含`.conditions`列分配结果的数据（CSV 格式），点击屏幕右上角的<i title="download" class="fa  fa-download"></i>图标。也可以通过为数据集命名并点击 “存储（Store）” 按钮，将相同数据存储到  Radiant 中。

### 报告 > Rmd

通过点击屏幕左下角的<i title="report results" class="fa fa-edit"></i>图标或按键盘上的`ALT-enter`，向<a href="https://radiant-rstats.github.io/docs/data/report_rmd.html" target="_blank">*报告 > Rmd*</a>添加代码以（重新）生成样本。

### R 函数

有关 Radiant 中用于抽样和样本量计算的相关 R 函数概述，请参见<a href =  "https://radiant-rstats.github.io/radiant.design/reference/index.html#section-design-sample" target="_blank">*设计 > 样本*</a>。

更多信息请参见 Radiant 的 “随机分配” 工具所使用的`randomizr`包的<a  href="https://cran.r-project.org/web/packages/randomizr/vignettes/randomizr_vignette.html" target="_blank">说明文档</a>。

`randomizer`工具中使用的来自`randomizr`包的核心函数是`complete_ra`和`block_ra`。
