# Radiant - 使用R和Shiny进行商业分析

<!-- [![Build Status](https://travis-ci.org/radiant-rstats/radiant.png?branch=master)](https://travis-ci.org/radiant-rstats/radiant) -->
<!-- [![Coverage Status](https://img.shields.io/coveralls/vnijs/radiant.svg)](https://coveralls.io/r/vnijs/radiant?branch=master) -->
[![CRAN\_Status\_Badge](http://www.r-pkg.org/badges/version/radiant)](https://CRAN.R-project.org/package=radiant)


Radiant是一个开源的、与平台无关的、基于浏览器的[R ](https://www.r-project.org/)商业分析界面。该应用程序基于[Shiny ](https://shiny.posit.co/)包构建，可以在本地或服务器上运行。Radiant由<a href="https://rady.ucsd.edu/faculty-research/faculty/vincent-nijs.html  " target="\_blank">Vincent Nijs</a>开发。请使用GitHub上的问题跟踪器提出改进建议或报告问题：[https://github.com/radiant-rstats/radiant/issues。其他问题和评论请使用radiant@rady.ucsd.edu。 ](https://github.com/radiant-rstats/radiant/issues。其他问题和评论请使用radiant@rady.ucsd.edu。)

## 主要特性

- **探索**：快速轻松地汇总、可视化和分析您的数据
- **跨平台**：它在Windows、Mac和Linux上的浏览器中运行
- **可重现**：通过状态文件或[Rmarkdown ](https://rmarkdown.rstudio.com/)报告重新创建结果并与他人共享工作
- **编程**：将Radiant的分析功能与您自己的R代码集成
- **上下文**：数据和示例侧重于商业应用

<iframe width="640" height="375" src="https://www.youtube.com/embed/7L3hDpLw53I" frameborder="0" allowfullscreen></iframe>

#### 播放列表

有两个包含视频教程的YouTube播放列表。第一个提供了Radiant关键特性的总体介绍。第二个涵盖了商业分析课程中相关的主题（即概率、决策分析、假设检验、线性回归和模拟）。

* <a href="https://www.youtube.com/playlist?list=PLNhtaetb48EedDmWPUqytnQv-qxmCGtxi" target="_blank">Radiant入门</a>
* <a href="  https://www.youtube.com/playlist?list=PLNhtaetb48EdKRIY7MewCyvb_1x7dV3xw" target="_blank">Radiant教程系列</a>

#### 探索 

Radiant是交互式的。当输入更改时（即，没有单独的对话框）和/或按下按钮时（例如，_Model > Estimate > Logistic regression (GLM)_中的`Estimate`），结果会立即更新。这有助于快速探索和理解数据。 

#### 跨平台 

Radiant可在Windows、Mac或Linux上工作。它可以在没有互联网连接的情况下运行，并且没有数据会离开您的计算机。您也可以在服务器上将应用程序作为Web应用程序运行。 

#### 可重现 

要进行高质量分析，仅仅保存输出是不够的。您需要能够针对相同数据和/或当新数据可用时重现结果。此外，其他人可能希望查看您的分析和结果。保存和加载应用程序状态，以便稍后或在另一台计算机上继续工作。与他人共享状态文件，并使用[Rmarkdown ](https://rmarkdown.rstudio.com/)创建可重现的报告。另请参阅下面的"保存和加载状态"部分。 

如果您在服务器上使用Radiant，您甚至可以与他人共享URL（包含SSUID），以便他们可以看到您正在处理的内容。感谢[Joe Cheng ](https://github.com/jcheng5)提供此功能。 

#### 编程 

尽管Radiant的Web界面可以处理相当多的数据和分析任务，但您可能更喜欢编写自己的R代码。Radiant通过导出用于分析的函数，为R(studio)编程提供了桥梁（即，您可以使用Radiant Web界面进行分析，也可以直接从R代码调用Radiant的函数）。有关使用Radiant进行编程的更多信息，请参阅文档网站上的[编程 ](https://radiant-rstats.github.io/docs/programming.html)页面。 

#### 上下文 

Radiant专注于商业数据和决策。它提供了与该上下文相关的工具、示例和文档，有效降低了商业分析的学习曲线。 

## 如何安装Radiant 

- 必需：[R ](https://cran.r-project.org/)版本4.0.0或更高
- 必需：[Rstudio ](https://posit.co/download/rstudio-server/)

在Rstudio中，您可以通过屏幕顶部的`Addins`菜单启动和更新Radiant。要为Windows或Mac安装最新版本的Radiant（包含完整的离线文档），请打开R(studio)并复制粘贴以下命令：

```r
options(repos = c(RSM = "https://radiant-rstats.github.io/minicran", CRAN = "https://cloud.r-project.org"))
install.packages("radiant")
```

安装完所有包后，从Rstudio中的`Addins`菜单选择`Start radiant`，或使用以下命令启动应用程序：

```r
radiant::radiant()
```

要在Rstudio的查看器窗格中启动Radiant，请使用以下命令：

```r
radiant::radiant_viewer()
```

要在Rstudio窗口中启动Radiant，请使用以下命令：

```r
radiant::radiant_window()
```

要轻松更新Radiant和所需包，请使用以下命令安装`radiant.update`包：

```r
options(repos = c(RSM = "https://radiant-rstats.github.io/minicran", CRAN = "https://cloud.r-project.org"))
install.packages("remotes")
remotes::install_github("radiant-rstats/radiant.update", upgrade = "never")
```

然后从Rstudio中的`Addins`菜单选择`Update radiant`，或使用以下命令：

```r
radiant.update::radiant.update()
```

有关更多详细信息，请参阅[安装radiant ](https://radiant-rstats.github.io/docs/install.html)页面。 

**可选：** 您还可以通过在R(studio)控制台中键入`radiant::launcher()`并按回车键，在桌面上创建启动器来启动Radiant。将创建一个名为`radiant.bat`（Windows）或`radiant.command`（Mac）的文件，您可以双击该文件在默认浏览器中启动Radiant。`launcher`命令还将创建一个名为`update_radiant.bat`（Windows）或`update_radiant.command`（Mac）的文件，您可以双击该文件将Radiant更新到最新版本。 

当Radiant启动时，您将看到有关钻石价格的数据。要关闭应用程序，请单击导航栏中的<i title='Power off' class='fa fa-power-off'></i>图标，然后单击`Stop`。Radiant进程将停止，浏览器窗口将关闭（Chrome）或变灰。 

## 文档 

文档和教程可在<[https://radiant-rstats.github.io/docs/ ](https://radiant-rstats.github.io/docs/)  >获取，并在Radiant Web界面中（每页上的<i title='Help' class='fa fa-question'></i>图标和导航栏中的<i title='Help' class='fa fa-question-circle'></i>图标）。 

各个Radiant包也有自己的[pkgdown ](https://github.com/r-lib/pkgdown)网站： 

* http://radiant-rstats.github.io/radiant
* http://radiant-rstats.github.io/radiant.data
* http://radiant-rstats.github.io/radiant.design
* http://radiant-rstats.github.io/radiant.basics
* http://radiant-rstats.github.io/radiant.model
* http://radiant-rstats.github.io/radiant.multivariate

需要一些入门帮助吗？观看[文档网站 ](https://radiant-rstats.github.io/docs/tutorials.html)上的教程。

## 报告问题 

如果您在使用Radiant时遇到任何问题，请使用GitHub问题跟踪器：<a href="https://github.com/radiant-rstats/radiant/issues  " target="_blank">github.com/radiant-rstats/radiant/issues</a>。 

## 在线试用Radiant 

还没有准备好在计算机上安装Radiant？在以下链接在线试用： 

<a href="https://vnijs.shinyapps.io/radiant  " target="_blank">https://vnijs.shinyapps.io/radiant  </a> 

请**不要**将敏感数据上传到此公共服务器。出于安全原因，数据上传大小已限制为10MB。 

## 在shinyapps.io上运行Radiant 

要在shinyapps.io上运行您自己的Radiant实例，首先<a href = "https://radiant-rstats.github.io/docs/install.html  " target = "_blank">安装Radiant及其依赖项</a>。然后克隆<a href="https://github.com/radiant-rstats/radiant  " target="_blank">radiant</a>仓库，并通过运行`radiant/inst/app/for.shinyapps.io.R`确保您已安装最新版本的Radiant包。最后，打开`radiant/inst/app/ui.R`并[部署 ](https://shiny.posit.co/articles/shinyapps.html)应用程序。 

## 在shiny-server上运行Radiant 

您也可以使用[shiny-server ](https://posit.co/download/shiny-server/)托管Radiant。首先，使用以下命令在服务器上安装radiant： 

```r
options(repos = c(RSM = "https://radiant-rstats.github.io/minicran", CRAN = "https://cloud.r-project.org"))
install.packages("radiant")
```

然后克隆<a href="https://github.com/radiant-rstats/radiant  " target="_blank">radiant</a>仓库，并将shiny-server指向`inst/app/`目录。如果您打算在服务器上使用Radiant，请告知我，我将不胜感激。 

在服务器上运行Radiant时，默认情况下，文件上传限制为10MB，并且出于安全原因，_Report > Rmd_和_Report > R_中的R代码不会被评估。如果您拥有服务器的`sudo`访问权限并有适当的安全措施，可以通过向服务器上`shiny`用户的`.Rprofile`添加以下行来更改这些设置。 

```bash
options(radiant.maxRequestSize = -1)  ## no file size limit
options(radiant.report = TRUE)
```

## 在云中运行Radiant（例如，AWS） 

要在云中运行radiant，您可以使用自定义Docker容器。详情请参见<a href = "https://github.com/radiant-rstats/docker  " target="_blank">https://github.com/radiant-rstats/docker  </a> 

## 保存和加载状态 

要保存您的分析，请单击导航栏中的<i title='Save' class='fa fa-save'></i>图标，然后单击`Save radiant state file`（另请参见_Data > Manage_选项卡）将应用程序状态保存到文件中。您可以稍后或在另一台计算机上打开此状态文件，继续您之前的工作。您也可以与希望复制您分析的其他人共享该文件。例如，单击导航栏中的<i title='Save' class='fa fa-save'></i>图标，然后单击`Load radiant state file`，加载状态文件[`radiant-example.state.rda` ](https://radiant-rstats.github.io/docs/examples/radiant-example.state.rda)。转到_Data > View_和_Data > Visualize_查看应用程序先前"状态"的一些设置。_Report > Rmd_中还有一个使用Radiant界面创建的报告。html文件<a href="https://radiant-rstats.github.io/docs/examples/radiant-example.nb.html  " target="_blank">`radiant-example.nb.html`</a>包含输出。 

Radiant中的一个相关功能是，如果您意外导航到另一个网页、关闭（并重新打开）浏览器和/或点击刷新，状态将保持不变。在导航栏中的<i title='Power off' class='fa fa-power-off'></i>菜单中使用`Refresh`返回到干净/新的状态。 

加载和保存状态也适用于Rstudio。如果您从Rstudio启动Radiant并使用<i title='Power off' class='fa fa-power-off'></i> > `Stop`停止应用程序，则名为`r_data`、`r_info`和`r_state`的列表将放入Rstudio的全局工作空间中。如果您再次使用`radiant::radiant()`启动radiant，它将使用这些列表来恢复状态。此外，如果您直接将状态文件加载到Rstudio中，启动Radiant时将使用该文件重新创建先前的状态。 

**技术说明**：Radiant中的状态加载工作方式如下：当在Shiny应用程序中初始化输入时，您在调用（例如，numericInput）中设置默认值。在Radiant中，当加载状态文件并初始化输入时，它会查看名为`r_state`的列表中是否有该名称的输入值。如果有，则使用该值。`r_state`列表是在使用`reactiveValuesToList(input)`保存状态时创建的。下面给出了调用`numericInput`的示例，其中使用了来自`radiant.R`的`state_init`函数来检查是否可以使用来自`r_state`的值。 

```r
numericInput("sm_comp_value", "Comparison value:", state_init("sm_comp_value", 0))
```

## 源代码 

Radiant应用程序的源代码可在GitHub上获取：<[https://github.com/radiant-rstats ](https://github.com/radiant-rstats)  >。`radiant.data`提供工具来加载、保存、查看、可视化、汇总、组合和转换数据。`radiant.design`基于`radiant.data`构建，并添加了用于实验设计、抽样和样本量计算的工具。`radiant.basics`涵盖了统计分析的基础知识（例如，比较均值和比例、交叉表、相关性等），并包括一个概率计算器。`radiant.model`涵盖了模型估计（例如，逻辑回归和神经网络）、模型评估（例如，增益图、利润曲线、混淆矩阵等）和决策工具（例如，决策分析和模拟）。最后，`radiant.multivariate`包括生成品牌地图以及进行聚类、因子和联合分析的工具。 

这些工具用于加州大学圣地亚哥分校Rady管理学院的_Business Analytics_、*Quantitative Analysis*、*Research for Marketing Decisions*、*Applied Market Research*、*Consumer Behavior*、*Experiments in Firms*、*Pricing*、_Pricing Analytics_和_Customer Analytics_课程。 

## 致谢 

没有[R ](https://cran.r-project.org/)和[Shiny ](https://shiny.posit.co/)，Radiant是不可能实现的。我要感谢[Joe Cheng ](https://github.com/jcheng5)、[Winston Chang ](https://github.com/wch)和[Yihui Xie ](https://github.com/yihui)回答问题、提供建议并为R社区创建出色的工具。Radiant中使用的其他关键组件包括ggplot2、dplyr、tidyr、magrittr、broom、shinyAce、shinyFiles、rmarkdown和DT。有关Radiant所依赖的其他包的概述，请参阅<a href="https://radiant-rstats.github.io/docs/about.html  " target="_blank">关于</a>页面。 

## 许可证 

Radiant根据<a href="https://tldrlegal.com/license/gnu-affero-general-public-license-v3-  (agpl-3.0)" target="\_blank">AGPLv3</a>许可。简而言之，AGPLv3许可证要求：归属，包括软件副本中的版权声明和许可信息，如果代码被修改则说明更改，以及披露所有源代码。详情请参见COPYING文件。 

`radiant.data`包的文档、图像和视频根据知识共享署名和相同方式共享许可<a href="https://creativecommons.org/licenses/by-sa/4.0/  " target="_blank">CC-BY-SA</a>许可。本网站上的所有其他文档和视频，以及`radiant.design`、`radiant.basics`、`radiant.model`和`radiant.multivariate`的帮助文件，均根据知识共享署名、非商业性、相同方式共享许可<a href="https://creativecommons.org/licenses/by-nc-sa/4.0/  " target="_blank">CC-NC-SA</a>许可。 

如果您有兴趣使用任何radiant包，请通过[radiant@rady.ucsd.edu ](mailto:radiant@rady.ucsd.edu)给我发邮件。 

&copy; Vincent Nijs (2024) <a rel="license" href="https://creativecommons.org/licenses/by-sa/4.0/" target="_blank"><img alt="Creative Commons License" style="border-width:0" src="https://radiant-rstats.github.io/docs/images/by-sa.png" /></a>
