> 基于属性数据创建感知图，为大型数值表格提供丰富的可视化摘要

### 示例

要加载`retailers`数据，前往 “数据> 管理”，从 “加载数据类型（Load data of type）” 下拉菜单中选择`examples`，点击 “加载（Load）” 按钮，然后选择`retailers`数据集。该数据集包含芝加哥地区一组零售商在 7 个属性上的消费者评价信息。除属性评价外，数据集还包含两个预定义消费者细分群体对每个零售商的偏好评分（1-9 分制）。

选择`retailer`变量作为 “品牌（Brand）” 属性，这只是零售商名称 / 标签的列表。然后在 “属性（Attributes）” 框中选择变量`good_value`至`cluttered`，在 “偏好（Preferences）” 框中选择`segment1`和`segment2`变量。更改设置后，点击 “估计（Estimate）” 按钮或按`CTRL-enter`（Mac 上为`CMD-enter`）生成结果。

“属性（Attributes）” 框中的变量将通过因子分析进行分析，结果在 “摘要（Summary）”  标签页中提供。我们从二维解决方案开始。第一个表格显示品牌的因子得分，本质上是原始属性数据的加权平均值，其中权重为因子载荷。换句话说，因子得分是通过因子分析创建的（两个）变量，用于汇总原始 7 个属性中包含的信息。第二个数值表格显示因子载荷，代表原始属性与导出的因子得分之间的相关性。

我们还获得了关于两个导出因子捕捉属性中信息比例的信息。第一个因子捕捉原始数据 56.4% 的变异，第二个因子捕捉 42% 的变异。两个因子共同覆盖 98.4% 的变异，即从 7  个属性降至两个因子的维度降低过程中，信息损失仅为  1.6%。添加第三个因子只会略微增加捕捉的方差，但会使地图解释更困难。因此，我们将重点关注二维品牌地图。

偏好相关性表明受访者提供的偏好评分与发现的因子得分之间的关联强度。`Segment 2`的偏好与因子 2 呈极强的正相关，因此我们可能预期该细分群体的偏好箭头几乎垂直向上。公因子方差表明细分群体偏好中可被两个因子解释的变异比例，数值非常好（即  Segment 1 为 97.5%，Segment 2 为  91.5%）。从这些数值中我们可以推断，研究中选择的属性很好地反映了消费者偏好，这是有用的品牌地图研究的关键特征。选择与客户偏好无关的属性会导致品牌地图对管理者价值有限。

最后一个表格显示属性公因子方差，这些数值表明每个属性数据中可被两个因子解释的变异比例。前面提到的累积方差是跨属性的整体度量。但我们也希望了解每个单独属性是否能被两个因子很好地代表。本示例中的数值整体表现优异（即均超过 90%）。

<p align="center"><img src="figures_multivariate/prmap_summary.png"></p>

从仅显示品牌位置的地图开始会很有帮助。在 “绘图（Plot）” 标签页中勾选 “品牌（Brands）” 框创建地图。该图是因子 1  得分（水平轴）和因子 2 得分（垂直轴）的散点图。换句话说，品牌在因子 1 和因子 2  上的得分就是该品牌在地图中的坐标，零售商名称用作每个点的标签。

<p align="center"><img src="figures_multivariate/prmap_plot_brands.png"></p>

我们可以通过同时勾选 “品牌（Brands）” 和 “属性（Attributes）” 框，创建同时包含品牌位置（仍使用因子得分）和属性箭头（使用因子载荷）的品牌地图。箭头方向由属性与因子之间的相关程度（即因子载荷）决定。属性`Service`（服务）与因子 1 呈强正相关，因此主要指向因子 1 增值的方向（即向右）。由于`Service`与因子 2 的相关性略正，箭头向上而非向下。相反，属性`Convenience`（便利性）与因子 2 呈强正相关，因此主要指向因子 2 增值的方向（即向上）。由于其与因子 1 的相关性略正，箭头向右而非向左。箭头长度与 “摘要”  标签页中报告的公因子方差成比例，公因子方差越高，箭头越长。如果某个属性不能被导出的因子很好地汇总，其公因子方差会较低，该属性在品牌地图中的箭头会较短。

<p align="center"><img src="figures_multivariate/prmap_plot_brands_attr.png"></p>

最后，我们可以通过勾选 “偏好（Preferences）”  框将偏好信息添加到地图中。细分群体偏好箭头的方向由因子得分与偏好得分之间的相关性决定。由于分配到细分群体 2 的受访者对零售商的偏好与因子 2  高度相关，箭头几乎垂直向上。细分群体 1 的偏好得分与因子 1 和因子 2 均呈负相关，因此箭头指向左下方向。

<p align="center"><img src="figures_multivariate/prmap_plot_all.png"></p>

在图中，我们看到全食超市（Whole foods）和 Cub  食品超市在我们获取数据的属性上被感知为更具可比性，而例如全食超市和沃尔玛（Wal-Mart）则不然。管理者从图中可能会得出结论：地图上位置最接近的品牌被感知为密切替代品，因此在消费者心中是直接竞争对手。

没有属性信息的地图（例如基于（不）相似性数据的地图）的一个重要局限性是，难以解释品牌为何位置接近或疏远。如上图所示，通过向地图添加属性箭头，我们对地图中品牌位置的理解显著增强。例如，Jewel 和 Dominick's 在地图中位置较高，因为它们被感知为向消费者提供更高的便利性。同样，Cub  食品超市，尤其是全食超市，提供更高水平的客户服务和优质产品。我们还可以推断哪些可用属性与消费者偏好的关联最密切。细分群体 2  主要关注便利性，这可能解释了其对 Jewel 和 Dominick's 的较高偏好评分。同样，细分群体 2 最关注性价比（Good  value），而对商品种类（Assortment）不太关注，该群体更喜欢在 Treasure Island 和沃尔玛购物。

## 纳入分类变量

<!-- Attribute-based perceptual maps are calculated using Principal Components Analysis (PCA). The correlation matrix used as input for PCA can be calculated for variables of type `numeric`, `integer`, `date`, and `factor`. When variables of type factor are included the `Adjust for categorical variables` box should be checked. When correlations are estimated with adjustment, variables that are of type `factor` will be treated as (ordinal) categorical variables and all other variables will be treated as continuous. -->

基于属性的感知地图通过主成分分析（PCA）计算。用于 PCA 的相关矩阵目前仅可基于`numeric`、`integer`和`date`类型的变量计算。但偏好信息可以是`numeric`、`integer`、`date`和`factor`类型。当纳入因子型偏好变量时，因子得分与偏好数据之间的相关性将使用`polycor::hetcor`计算。因子型变量将被视为（有序）分类变量，其他所有变量将被视为连续变量。

### 报告 > Rmd

通过点击屏幕左下角的<i title="report results" class="fa fa-edit"></i>图标或按键盘上的`ALT-enter`，向<a href="https://radiant-rstats.github.io/docs/data/report_rmd.html" target="_blank">*报告 > Rmd*</a>添加代码以（重新）创建分析。

### R 函数

有关 Radiant 中用于生成品牌地图的相关 R 函数概述，请参见<a href =  "https://radiant-rstats.github.io/radiant.multivariate/reference/index.html#section-multivariate-maps" target="_blank">*多元分析 > 感知图*</a>。

`prmap`工具中使用的核心函数包括`stats`包中的`cor`和`cov`，以及`psych`包中的`principal`。
