% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalreg.R
\name{plot.evalreg}
\alias{plot.evalreg}
\title{Plot method for the evalreg function}
\usage{
\method{plot}{evalreg}(x, vars = c("Rsq", "RMSE", "MAE"), ...)
}
\arguments{
\item{x}{Return value from \code{\link{evalreg}}}

\item{vars}{Measures to plot, i.e., one or more of "Rsq", "RMSE", "MAE"}

\item{...}{further arguments passed to or from other methods}
}
\description{
Plot method for the evalreg function
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/evalreg.html} for an example in Radiant
}
\examples{
data.frame(price = diamonds$price, pred1 = rnorm(3000), pred2 = diamonds$price) \%>\%
  evalreg(pred = c("pred1", "pred2"), "price") \%>\%
  plot()

}
\seealso{
\code{\link{evalreg}} to generate results

\code{\link{summary.evalreg}} to summarize results
}
