> 使用简单随机抽样从抽样框中选择观测值

使用抽样工具时，需选择数据集中每行均唯一（即无重复）的数据集。Radiant 中捆绑了一个符合此要求的数据集，可通过 “数据> 管理” 标签页获取（即从 “加载数据类型（Load data of type）” 下拉菜单中选择`Examples`，然后点击 “加载（Load）”）。从 “数据集（Datasets）” 下拉菜单中选择`rndnames`。

`Names`是该数据集中的唯一标识符。如果我们选择这个变量并选择所需的样本量（例如 10），将生成所需长度的名称列表。

抽样原理是什么？数据中的每个人被分配一个来自均匀分布的 0 到 1 之间的随机数。然后根据该随机数对行进行排序，从列表中选取得分最高的n人作为样本。通过使用随机数，每个受访者被选入样本的概率相同。例如，如果我们需要从`rndnames`数据集中的 100 人中抽取 10 人的样本，每个人被纳入样本的概率为 10%。默认情况下，随机种子设为`1234`，以确保抽样结果可重复。如果 “随机种子（Rnd. seed）” 输入框为空，每次生成样本时所选行都会变化。

<p align="center"><img src="figures_design/sampling.png"></p>

这 100 人的完整列表称为 “抽样框（sampling frame）”。理想情况下，这是目标市场中**所有**抽样单位（如客户或公司）的综合列表。要确定n的适当值，请使用 “设计（Design）” 菜单中的样本量工具。要显示完整的抽样框，点击 “显示抽样框（Show sampling frame）” 复选框。

要下载生成的样本数据（CSV 格式），点击屏幕右上角的<i title="download" class="fa  fa-download"></i>图标。也可以通过为数据集命名并点击 “存储（Store）” 按钮，将创建的样本存储到  Radiant 中。

### 报告 > Rmd

通过点击屏幕左下角的<i title="report results" class="fa fa-edit"></i>图标或按键盘上的`ALT-enter`，向<a href="https://radiant-rstats.github.io/docs/data/report_rmd.html" target="_blank">*报告 > Rmd*</a>添加代码以（重新）生成样本。

### R 函数

有关 Radiant 中用于抽样和样本量计算的相关 R 函数概述，请参见<a href =  "https://radiant-rstats.github.io/radiant.design/reference/index.html#section-design-sample" target="_blank">*设计 > 样本*</a>。

`sampling`工具中使用的来自`stats`包的核心函数是`runif`。该函数用于生成分配给可用数据中每行的随机数。
