> 交叉表分析用于评估分类变量之间是否存在关联。该工具也被称为卡方检验或列联表分析

### 示例

数据来自 580 名报纸读者的样本，这些读者表明了（1）他们最常阅读的报纸（《今日美国》或《华尔街日报》）和（2）他们的收入水平（低收入 vs.  高收入）。数据包含三个变量：受访者标识符（id）、受访者收入（高或低）以及受访者主要阅读的报纸（《今日美国》或《华尔街日报》）。

我们将研究收入水平与报纸选择之间是否存在关系。具体而言，我们检验以下原假设和备择假设：

* H0：收入水平与报纸选择之间无关联
* Ha：收入水平与报纸选择之间有关联

如果拒绝原假设，我们可以进一步研究哪些单元格对假设的关联有贡献。在 Radiant（基础 >  交叉表）中，选择收入作为第一个因子，报纸作为第二个因子。首先，比较观察频数和期望频数。期望频数基于原假设（即无关联）计算，公式为（行总计 ×  列总计）/ 总总计。

<p align="center"><img src="figures_basics/cross_tabs_summary.png"></p>

（皮尔逊）卡方检验用于评估我们是否可以拒绝两个变量独立的原假设。它通过比较观察频数（即数据中实际看到的频数）与期望频数（即如果两个变量独立时预期看到的频数）来实现。如果期望频数表与观察频数表之间存在较大差异，卡方值将**较大**。每个单元格的卡方值计算公式为`(o - e)^2 / e`，其中`o`是单元格中的观察频数，`e`是原假设成立时该单元格的期望频数。点击 “卡方（Chi-squared）” 复选框可显示这些值。总卡方值通过对所有单元格求和获得，即它是 “卡方贡献（Contribution to chi-square）” 表中所示值的总和。

为了确定卡方值是否可被视为**较大**，我们首先计算自由度（df）。具体而言：自由度 =（行数 - 1）×（列数 - 1）。在 2×2 表格中，自由度 =（2-1）×（2-1）=1。“摘要（Summary）”  标签页的输出显示了卡方统计量的值、相关的自由度以及检验的 p 值。我们还能看到每个单元格对总卡方统计量的贡献。

记住要检查期望値：所有期望频数均大于 5，因此卡方统计量的 p 值不太可能存在偏差。与通常一样，当 p 值小于 0.05 时，我们拒绝原假设。由于我们的 p 值非常小（<0.001），我们可以拒绝原假设（即数据表明报纸阅读习惯与收入之间存在关联）。

我们可以使用与 187.783 的卡方值相关的 p 值来评估原假设。不过，我们也可以使用概率计算器计算临界卡方值。从下方输出中可以看到，如果选择 95%  的置信水平，该值为 3.841。由于计算得到的卡方值大于临界值（187.783 > 3.841），我们拒绝 “收入（Income）” 与  “报纸（Newspaper）” 独立的原假设。

<p align="center"><img src="figures_basics/compare_props_prob_calc.png"></p>

我们也可以使用概率计算器确定与计算得到的卡方值相关的 p 值。与 “交叉表> 摘要” 标签页的输出一致，该`p.value`为`< .001`。

<p align="center"><img src="figures_basics/cross_tabs_chi_pvalue.png"></p>

除 “摘要” 标签页中的数值输出外，我们还可以可视化评估假设（见 “绘图（Plot）”  标签页）。我们选择与之前相同的变量，但将绘制标准化偏差。该度量的计算公式为（o-e）/sqrt  (e)，即衡量表格中某个单元格的观察频数与期望频数差异的得分。当单元格的标准化偏差绝对值大于 1.96  时，该单元格与独立性模型（或无关联）存在显著偏差。

<p align="center"><img src="figures_basics/cross_tabs_plot.png"></p>

在图中，我们看到所有单元格都对收入与阅读习惯之间的关联有贡献，因为所有标准化偏差的绝对值都大于 1.96（即条形图延伸超出了图中的外部虚线）。

换句话说，与无关联的原假设成立时的预期相比，阅读《华尔街日报》的低收入受访者似乎更少，阅读《华尔街日报》的高收入受访者似乎更多；此外，阅读《今日美国》的低收入受访者更多，阅读《今日美国》的高收入受访者更少。

### 报告 > Rmd

通过点击屏幕左下角的<i title="report results" class="fa fa-edit"></i>图标或按键盘上的`ALT-enter`，向<a href="https://radiant-rstats.github.io/docs/data/report_rmd.html" target="_blank">*报告 > Rmd*</a>添加代码以（重新）创建分析。

如果已创建图表，可使用`ggplot2`命令进行自定义（例如，`plot(result, check = "observed", custom = TRUE) + labs(y = "百分比")`）。详情请参见<a href="https://radiant-rstats.github.io/docs/data/visualize.html" target="_blank">*数据 > 可视化*</a>。

### 技术说明

当一个或多个期望値较小时（例如≤5），卡方检验的 p 值通过模拟方法计算。如果某些单元格的期望计数低于 1，可能需要**合并**行和 / 或列。

### R 函数

有关 Radiant 中用于评估分类变量间关联的相关 R 函数概述，请参见<a href =  "https://radiant-rstats.github.io/radiant.basics/reference/index.html#section-basics-tables" target="_blank">*基础 > 表格*</a>。

`cross_tabs`工具中使用的来自`stats`包的核心函数是`chisq.test`。

### 视频教程

将以下完整命令复制粘贴到 RStudio 控制台（即左下角窗口），按回车即可获取 Radiant 教程系列中假设检验模块使用的所有材料：

<pre>usethis::use_course("https://www.dropbox.com/sh/0xvhyolgcvox685/AADSppNSIocrJS-BqZXhD1Kna?dl=1")</pre>

<a href="https://youtu.be/MEt8vO5FNYQ" target="_blank">交叉表假设检验</a>

- 本视频演示如何通过交叉表假设检验研究两个分类变量之间的关联
- 主题列表：
  - 在 Radiant 中设置交叉表的假设检验
  - 解释观察频数表、期望频数表和卡方贡献表的构建方式
  - 使用 p 值和临界值评估假设检验
