## urls for menu
r_url_list <- getOption("radiant.url.list")
r_url_list[["Single mean"]] <-
  list("tabs_single_mean" = list("Summary" = "basics/single-mean/", "Plot" = "basics/single-mean/plot/"))
r_url_list[["Compare means(t-test/Wilcoxon rank-sum test)"]] <-
  list("tabs_compare_means" = list("Summary" = "basics/compare-means/", "Plot" = "basics/compare-means/plot/"))
r_url_list[["Multigroup Difference Analysis(ANOVA/Kruskal-Wallis)"]] <-
  list("tabs_mda" = list("Summary" = "basics/mda/", "Plot" = "basics/mda/plot/"))
r_url_list[["Single proportion"]] <-
  list("tabs_single_prop" = list("Summary" = "basics/single-prop/", "Plot" = "basics/single-prop/plot/"))
r_url_list[["Compare proportions"]] <-
  list("tabs_compare_props" = list("Summary" = "basics/compare-props/", "Plot" = "basics/compare-props/plot/"))
r_url_list[["Goodness of fit"]] <-
  list("tabs_goodness" = list("Summary" = "basics/goodness/", "Plot" = "basics/goodness/plot/"))
r_url_list[["Cross-tabs(Chi-square test, etc)"]] <-
  list("tabs_cross_tabs" = list("Summary" = "basics/cross-tabs/", "Plot" = "basics/cross-tabs/plot/"))
r_url_list[["Correlation"]] <-
  list("tabs_correlation" = list("Summary" = "basics/correlation/", "Plot" = "basics`/correlation/plot/"))
options(radiant.url.list = r_url_list)
rm(r_url_list)

## try http://127.0.0.1:3174/?url=basics/goodness/plot/&SSUID=local
## http://127.0.0.1:7407/?url=basics/compare-means/plot/&SSUID=local-a82049

## design menu
options(
  radiant.basics_ui =
    tagList(
      navbarMenu(
        i18n$t("Basics"),
        tags$head(
          tags$script(src = "www_basics/js/run_return.js")
        ),
        i18n$t("Data Quality"),
        tabPanel(i18n$t("Missing Value Analysis"), uiOutput("missing")),
        tabPanel(i18n$t("Outlier Analysis"), uiOutput("outlier")),
        i18n$t("Probability"),
        tabPanel(i18n$t("Probability calculator"), uiOutput("prob_calc")),
        tabPanel(i18n$t("Central Limit Theorem"), uiOutput("clt")),
        "----", i18n$t("Means"),
        tabPanel(i18n$t("Single mean"), uiOutput("single_mean")),
        tabPanel(i18n$t("Compare means(t-test/Wilcoxon rank-sum test)"), uiOutput("compare_means")),
        #tabPanel(i18n$t("Normality test"),uiOutput("normality_test")),
        #tabPanel(i18n$t("Homogeneity of variance test"),uiOutput("homo_variance_test")),
        tabPanel(i18n$t("Multigroup Difference Analysis(ANOVA/Kruskal-Wallis)"),uiOutput("mda")),
        "----", i18n$t("Proportions"),
        tabPanel(i18n$t("Single proportion"), uiOutput("single_prop")),
        tabPanel(i18n$t("Compare proportions"), uiOutput("compare_props")),
        "----", i18n$t("Tables"),
        tabPanel(i18n$t("Goodness of fit"), uiOutput("goodness")),
        tabPanel(i18n$t("Cross-tabs(Chi-square test, etc)"), uiOutput("cross_tabs")),
        tabPanel(i18n$t("Correlation"), uiOutput("correlation"))
      )
    )
)
