> 使用 Rmarkdown 创建（可重复的）报告

在 Radiant 中存储工作的最佳方式是使用 “报告> Rmd”  功能，并保存包含所有结果和设置的状态文件。Radiant 的报告功能应与大多数页面左下角显示的<i title='Report  results' class='fa fa-edit'></i>图标结合使用。

“报告> Rmd” 左侧的编辑器中，以**R 代码块**形式显示过往命令。这些 “代码块” 可包含你输入的 R 代码，或 Radiant 生成的代码（点击<i title='Report results' class='fa fa-edit'></i>图标后添加到报告中）。所有代码块均以````{r}`开头，以`````结尾。

默认情况下，Radiant 会将你刚完成的分析所生成的 R 代码添加到报告底部。点击<i title='Report results'  class='fa fa-edit'></i>图标后，Radiant 默认会切换到 “报告> Rmd”  标签页。点击左侧编辑器窗口并向下滚动，即可看到生成的命令。

如果你想更精确地控制 Radiant 生成的 R 代码在报告中的位置，可在 “报告> Rmd” 标签页的相应下拉菜单中选择  `手动粘贴`而非 `自动粘贴`。选择 `手动粘贴` 后，点击<i  title='Report results' class='fa  fa-edit'></i>时，代码会被复制到剪贴板，你可将其粘贴到编辑器窗口的任意位置。

如果你从 RStudio 启动 Radiant，还可选择将命令发送到 RStudio 中打开的 Rmarkdown（R  代码）文档，方法是在下拉菜单中选择 “> Rmd”（或 “> R”）而非 “自动粘贴” 或 “手动粘贴”。选择 “> Rmd” 后，“报告 > Rmd” 中的编辑器会隐藏（即 “仅预览”），点击 “编译报告（Rmd）” 会直接从 RStudio 获取文本和代码。

默认情况下，点击<i title='Report results' class='fa  fa-edit'></i>图标后，应用会切换到 “报告> Rmd” 标签页。但如果你不想在点击该图标后切换标签页，可在  “报告 > Rmd” 标签页的相应下拉菜单中选择 `不切换标签页`。当选择 “> Rmd”  时，“不切换标签页” 为默认选项。

你可以添加文本或额外命令来创建 Rmarkdown 文档。Rmarkdown 文件（扩展名为.Rmd）是纯文本文件，可在记事本（Windows）、文本编辑（Mac）、RStudio、Sublime Text 或任何其他文本编辑器中打开。请**不要**使用 Word 编辑 Rmarkdown 文件。

使用 Rmarkdown 的强大之处在于，你无需重新生成所有必要的 R 代码，就能快速复现整个分析。点击屏幕左上角的 “编译报告（Rmd）”  按钮后，分析输出会被（重新）生成并显示在 “报告 > Rmd” 页面的右侧。要仅执行报告的一部分，用光标选中该部分并按`CTRL-enter`（Mac 上为`CMD-enter`）生成（部分）输出。

你可以在代码块周围添加文本、项目符号、标题等，使用<a  href="https://rmarkdown.rstudio.com/authoring_pandoc_markdown.html"  target="_blank">markdown</a>格式描述和解释结果。如需交互式 markdown  教程，请访问<a href="http://commonmark.org/help/" target="_blank">[commonmark.org](https://commonmark.org)</a>。

如果你从 RStudio 启动 Radiant，可将报告保存为多种格式（即笔记本、HTML、Word、PowerPoint 或  PDF）。有关生成 PowerPoint 演示文稿的更多信息，参见<a  href="https://bookdown.org/yihui/rmarkdown/powerpoint-presentation.html" target="_blank">https://bookdown.org/yihui/rmarkdown/powerpoint-presentation.html</a>。要保存编辑器中打开的 Rmarkdown 文件，选择 `Rmd`（或 `Rmd + Data(zip)`）并按 `保存报告`  按钮。之前保存的 Rmarkdown 文件可通过 `加载报告` 按钮加载到 Radiant 中。

你也可以点击 `读取文件` 按钮浏览文件，并生成将其读入 Radiant 的代码。例如，读取  rda、rds、xls、yaml 和 feather 格式的文件并将它们添加到 “数据集” 下拉菜单中。你还可以读取图像、R 代码和文本（如  Rmd 或 md）以包含在报告中。如果你想要加载的文件类型当前不支持，会返回文件路径。如果 Radiant 从 RStudio  项目启动，使用的文件路径将相对于项目根目录。同步到本地 Dropbox 或 Google Drive 文件夹的文件路径会使用`find_dropbox`和`find_gdrive`函数，以增强可重复性。

## 状态

保存分析和设置的最佳方式是，通过点击导航栏中的<i title='Save' class='fa  fa-save'></i>图标，然后点击 `保存 Radiant 状态文件`，将应用程序的 “状态” 保存到文件中。状态文件（扩展名为 rda）将包含：（1）Radiant  中加载的数据；（2）你正在进行的分析设置；（3）“报告 > Rmd” 和 “报告 > R”  中的所有报告或代码。将状态文件保存到硬盘，当你准备继续工作时，只需通过导航栏中的<i title='Save' class='fa  fa-save'></i>图标，然后点击 `加载 Radiant 状态文件`加载它即可。

如果你在课程中使用 Radiant，建议使用 “报告> Rmd” 功能完成作业和案例分析。完成后，点击 `保存报告` 按钮生成（HTML）笔记本（或 Word、PDF）报告。同时提交报告和状态文件。

## 选项

“报告> Rmd” 和 “报告 > R” 中使用的编辑器有多个选项可在`.Rprofile`中设置。你可以使用`usethis::edit_r_profile()`修改`.Rprofile`中的设置。

```r
options(radiant.ace_vim.keys = FALSE)
options(radiant.ace_theme = "cobalt")
options(radiant.ace_tabSize = 2)
options(radiant.ace_useSoftTabs = TRUE)
options(radiant.ace_showInvisibles = TRUE)
options(radiant.ace_autoComplete = "live")
options(radiant.powerpoint_style = "~/Dropbox/rmd-styles/style.potx")
options(radiant.word_style = "~/Dropbox/rmd-styles/style.docx")
options(radiant.theme = bslib::bs_theme(version = 4, bootswatch = "darkly"))
```

说明：

* `vim.keys`启用一组特殊的键盘快捷键。如果你从未使用过 VIM，可能不需要开启此选项
* 有关可用的编辑器主题概述，参见：`shinyAce::getAceThemes()`
* 默认情况下，制表符会转换为 2 个空格（即 “软制表符”）。你可以将使用的空格数从 2 更改为例如 4
* `showInvisibles`在编辑器中显示制表符和空格
* 自动完成有 “live”“enabled” 和 “disabled” 三个选项
* Radiant 对 Word 和 PowerPoint 文件有默认样式。不过，这些样式可替换为你创建的样式文件。点击下方链接将 Radiant 中使用的样式文件下载到你的电脑。编辑这些文件，并使用上述`options`函数告知 Radiant 你想要使用的样式文件位置。
    * <a  href="https://github.com/radiant-rstats/radiant.data/raw/master/inst/app/www/style.docx" target="_blank">Word 样式文件</a>
    * <a  href="https://github.com/radiant-rstats/radiant.data/raw/master/inst/app/www/style.potx" target="_blank">PowerPoint 样式文件</a>
* `theme`选项可用于更改 Radiant 界面的外观。有关可用主题的概述，参见：<a  href="https://rstudio.github.io/bslib/articles/theming/index.html#bootswatch" target="_blank">https://rstudio.github.io/bslib/articles/theming/index.html#bootswatch</a></a>

### R 函数

有关 Radiant 中用于生成可重复报告的相关 R 函数概述，请参见<a href = "  https://radiant-rstats.github.io/radiant.data/reference/index.html#section-data-report" target="_blank">*报告*</a> 。
