## urls for menu
r_url_list <- getOption("radiant.url.list")
r_url_list[["Generate descriptive statistics with one click"]] <- "quickgen/basic/"
r_url_list[["AI chat guidance"]] <- "quickgen/chat/"
r_url_list[["LLM generates descriptive statistics"]] <- "quickgen/ai/"
options(radiant.url.list = r_url_list)
rm(r_url_list)

## quickgen menu
options(
  radiant.quickgen_ui =
    tagList(
      navbarMenu(
        i18n$t("Oneclick generation"),
        tags$head(
          tags$script(src = "www_quickgen/js/run_return.js")
        ),
        tabPanel(i18n$t("Generate descriptive statistics with one click"), uiOutput("quickgen_basic")),
        tabPanel(i18n$t("AI chat guidance"), uiOutput("quickgen_chat")),
        tabPanel(i18n$t("AI generates descriptive statistics"), uiOutput("quickgen_ai"))
      )
    )
)