> 创建透视表以探索你的数据

如果你使用过 Excel 中的透视表，那么 “数据> 透视表”  标签页提供的功能对你来说会很熟悉。与<a  href="https://radiant-rstats.github.io/docs/data/explore.html"  target="_blank">“数据> 探索”</a>标签页类似，你可以为数据中的变量生成汇总统计量，也可以生成频数表。“数据> 透视”  中最强大的功能或许是，你可以轻松地**按**一个或多个其他变量来描述数据。

例如，加载`diamonds`数据后，从 `分类变量` 下拉菜单中选择`clarity`和`cut`。第一个变量的类别将作为列标题，但你可以通过拖放所选变量来更改它们的顺序。选择这两个变量并点击 `生成透视表`按钮后，会显示不同净度和切工等级钻石的频数表。从 `归一化方式` 下拉菜单中选择 `行`、`列` 或 `总计`，可按行、列或总计数对单元格频数进行归一化，或根据汇总统计量创建指数。如果选择了归一化选项，勾选 `百分比` 框将数值表示为百分比会很方便。从 `条件格式化`  下拉菜单中选择 `色条` 或 `热力图`，可突出显示最高频数。

I也可以汇总数值变量。从 `数值变量`下拉菜单中选择`price`，将生成下方所示的表格。就像在<a href="https://radiant-rstats.github.io/docs/data/view.html"  target="_blank">“数据> 查看”</a>标签页中一样，你可以通过点击列标题对表格排序。你也可以使用滑块（例如，点击`I1`下方的输入框）将视图限制在指定范围内的值。要仅查看切工为 “Very good”“Premium” 或 “Ideal” 的钻石信息，点击`cut`标题下方的输入框。

<p align="center"><img src="figures/pivotr.png"></p>

以下是 “应用函数（Apply function）” 下拉菜单中几个函数的简要说明。不过，大多数函数的含义不言自明。

* `n`计算数据中的观测数（或行数）；若指定了 “分组依据（Group by）” 变量，则计算每组中的观测数（`n`使用 R 中的`length`函数）
* `n_distinct`计算不同值的数量
* `n_missing`计算缺失值的数量
* `cv`是变异系数（即 mean (x) /sd (x)）
* `sd`和`var`计算数值数据的样本标准差和方差
* `me`使用 95% 置信水平计算数值变量的误差边际
* `prop`计算比例。对于仅含 0 或 1 值的变量，其结果等同于`mean`。对于其他数值变量，它计算最大值的出现比例。对于`factor`，它计算第一个水平的出现比例。
* `sdprop`和`varprop`计算比例的样本标准差和方差
* `meprop`使用 95% 置信水平计算比例的误差边际
* `sdpop`和`varpop`计算总体标准差和方差

你也可以基于生成的表格创建条形图（见上图）。要下载 csv 格式的表格或 png 格式的图表，点击右侧相应的下载图标。

> 注意，当分类变量（`factor`）从 `数值变量`  下拉菜单中被选中时，若所选函数需要，该变量将被转换为数值变量。如果因子水平是数值型的，这些数值将用于所有计算。由于均值、标准差等统计量对非二元分类变量不适用，这类变量将被转换为 0-1（二元）变量，其中第一个水平编码为 1，其他所有水平编码为 0。

### 过滤数据

使用 “过滤数据（Filter data）” 框选择（或排除）数据中要制表的特定行集。详见<a  href="https://radiant-rstats.github.io/docs/data/view.html"  target="_blank">“数据> 查看（Data > View）”</a>的帮助文件。

### 存储

生成的透视表可以通过点击 `存储` 按钮存储到 Radiant 中。如果你想对表格进行进一步分析，或在<a  href="https://radiant-rstats.github.io/docs/data/visualize.html"  target="_blank">“数据> 可视化”</a>中基于汇总数据创建图表，这会很有用。要将表格下载为 csv 格式，点击右上角的下载图标。

### 报告 > Rmd

通过点击屏幕左下角的<i title="report results" class="fa fa-edit"></i>图标或按键盘上的`ALT-enter`，向<a href="https://radiant-rstats.github.io/docs/data/report_rmd.html"  target="_blank">“报告> Rmd”</a>添加代码以（重新）创建透视表。

如果已创建图表，可使用`ggplot2`命令进行自定义（例如，`plot(result) + labs(title = "透视图表")`）。详情请参见<a href="https://radiant-rstats.github.io/docs/data/visualize.html" target="_blank">“数据> 可视化”</a>。

### R 函数

有关 Radiant 中用于创建透视表的相关 R 函数概述，请参见<a href = "  https://radiant-rstats.github.io/radiant.data/reference/index.html#section-data-pivot" target="_blank">“数据> 透视”</a> 。
