> 可视化数据

### 过滤数据

使用 `过滤数据` 框选择（或排除）数据中的特定行集。详见<a  href="https://radiant-rstats.github.io/docs/data/view.html"  target="_blank">“数据> 查看”</a>的帮助文件。

### 图表类型

选择你想要的图表类型。例如，加载`diamonds`数据后，选择`分布` 和所有（X）变量（使用 CTRL-a 或  CMD-a）。这将为数据集中的所有数值变量创建直方图，为所有分类变量创建条形图。密度图仅可用于数值变量。散点图用于可视化两个变量之间的关系：选择一个或多个变量作为 Y 轴变量，一个或多个变量作为 X 轴变量。如果其中一个变量是分类变量（即因子 {factor}），应将其指定为 X 轴变量。可通过  “颜色（Color）” 或 “大小（Size）”  下拉菜单添加其他变量的信息。折线图与散点图类似，但会将数据点连接起来，特别适用于时间序列数据。曲面图与 “热力图（Heat maps）”  类似，需要 3 个输入变量：X、Y  和填充色（Fill）。条形图用于展示分类（或整数）变量（X）与数值变量（Y）的（均值）值之间的关系。箱线图也用于 Y 为数值变量、X  为分类变量的情况，它比条形图包含更多信息，但解读起来也稍复杂一些。

> 注意，在条形图中，当分类变量（`factor`）被选为 Y  轴变量时，若所选函数需要，该变量将被转换为数值变量。如果因子水平是数值型的，这些数值将用于所有计算。由于均值、标准差等统计量对非二元分类变量不适用，这类变量将被转换为 0-1（二元）变量，其中第一个水平编码为 1，其他所有水平编码为 0。例如，如果我们从`diamonds`数据中选择`color`作为 Y 轴变量，并选择`mean`作为应用函数，那么每个条形将表示取值为`D`的观测比例。

### 箱线图

箱线的上下 “边缘（hinges）” 对应数据的第一和第三四分位数（第 25 和第 75  百分位数）。中间的边缘是数据的中位数。上须线从上边缘（即箱体顶部）延伸至数据中在上边缘 1.5 倍四分位距范围内的最大值。四分位距（IQR）是第 25 和第 75 百分位数之间的距离。下须线从下边缘延伸至数据中下边缘 1.5  倍四分位距范围内的最小值。须线以外的数据可能是异常值，将以点的形式绘制（如 Tukey 所建议）。

总之：

1. 下须线从 Q1 延伸至数据最小值与（Q1 - 1.5×IQR）中的较大值
2. 上须线从 Q3 延伸至数据最大值与（Q3 + 1.5×IQR）中的较小值

其中 Q1 是第 25 百分位数，Q3 是第 75 百分位数。你可能需要多读几遍上述两点才能理解。下方图表有助于解释箱线图的结构。

<p align="center"><img src="figures/boxplot.png"></p>
<a href="http://en.wikipedia.org/wiki/File:Boxplot_vs_PDF.svg" target="_blank">来源</a>

### 子图和热力图

`行分面` 和 `列分面` 可用于将数据拆分为不同组，并为每组创建单独的图表。

如果选择散点图或折线图，会显示 “颜色（Color）” 下拉菜单。选择 “颜色” 变量将创建一种热力图，其中颜色与 “颜色” 变量的值相关联。在折线图中从 “颜色” 下拉菜单选择分类变量，会将数据拆分为组，并为每组显示不同颜色的线。

### 回归线、局部加权回归线和抖动

要在散点图中添加线性或非线性回归线，勾选 `线`和 / 或`局部加权回归`框。如果数据取值有限，`抖动`  功能有助于更好地了解大多数数据点的分布位置。`抖动` 会为每个数据点添加一个小的随机值，使它们在图表中不完全重叠。

### 坐标轴缩放

散点图中变量之间的关系可能是非线性的。我们可以对数据应用多种转换，使这种关系变为（近似）线性（见<a href="https://radiant-rstats.github.io/docs/data/transform.html"  target="_blank">“数据> 转换”</a>），以便更容易通过例如<a  href="https://radiant-rstats.github.io/docs/model/regress.html"  target="_blank">“模型> 估计 > 线性回归（OLS）”</a>进行估计。对业务数据最常用的数据转换可能是（自然）对数转换。要查看对数转换是否适合你的数据，勾选 “X  轴对数（Log X）” 和 / 或 “Y 轴对数（Log Y）” 框（例如，对于散点图或条形图）。

默认情况下，使用 `行分面` 时，所有子图的 Y 轴刻度相同。要使每个子图的 Y 轴刻度独立，点击 `Y 轴缩放` 复选框。

### 翻转坐标轴

要交换 X 轴和 Y 轴上的变量，勾选 `翻转` 框。

### 图表高度和宽度

要调整图表大小，修改屏幕左下角的高度和宽度输入框中的值。

### 保存图表

保存图表的最佳方式是通过点击屏幕左下角的报告（<i title='Report results' class='fa fa-edit'></i>）图标或按键盘上的`ALT-enter`生成`visualize`命令。或者，点击屏幕右上角的<i title='Download' class='fa fa-download'></i>图标将 png 文件保存到磁盘。

### 在 “报告> Rmd” 中定制图表

要定制图表，首先通过点击屏幕左下角的报告（<i title='Report results' class='fa fa-edit'></i>）图标或按键盘上的`ALT-enter`生成`visualize`命令。下方示例说明了如何在<a href="https://radiant-rstats.github.io/docs/data/report_rmd.html"  target="_blank">“报告> Rmd”</a>标签中定制命令。注意`custom`被设为`TRUE`。

```r
visualize(diamonds, yvar = "price", xvar = "carat", type = "scatter", custom = TRUE) +
  labs(
    title = "A scatterplot", 
    y = "Price in $",
    x = "Carats"
  )
```

图表的默认分辨率为 144 dots per inch（dpi）。你可以在 “报告> Rmd” 中调高或调低此设置。例如，下方代码块标题确保图表宽 7 英寸、高 3.5 英寸，分辨率为 600 dpi。

```` ```{r fig.width = 7, fig.height = 3.5, dpi = 600} ````

如果你安装了`svglite`包，下方代码块标题将生成高质量的`svg`格式图表。

```` ```{r fig.width = 7, fig.height = 3.5, dev = "svglite"} ````

**一些常见的定制命令：**

* 添加标题：`+ labs(title = "我的标题")`
* 添加副标题：`+ labs(subtitle = "我的副标题")`
* 在图表下方添加说明：`+ labs(caption = "基于……的数据")`
* 更改标签：`+ labs(x = "我的X轴标签")`或`+ labs(y = "我的Y轴标签")`
* 移除所有图例：`+ theme(legend.position = "none")`
* 更改图例标题：`+ labs(color = "新图例标题")`或`+ labs(fill = "新图例标题")`
* 旋转刻度标签：`+ theme(axis.text.x = element_text(angle = 90, hjust = 1))`
* 设置图表范围：`+ ylim(5000, 8000)`或`+ xlim("VS1","VS2")`
* 移除大小图例：`+ scale_size(guide = "none")`
* 更改大小范围：`+ scale_size(range=c(1,6))`
* 绘制水平线：`+ geom_hline(yintercept = 0.1)`
* 绘制垂直线：`+ geom_vline(xintercept = 8)`
* 将 Y 轴缩放为百分比：`+ scale_y_continuous(labels = scales::percent)`
* 将 Y 轴以百万为单位：`+ scale_y_continuous(labels = scales::unit_format(unit = "M", scale = 1e-6))`
* 以美元显示 Y 轴：`+ scale_y_continuous(labels = scales::dollar_format())`
* 使用逗号作为 Y 轴千位分隔符：`+ scale_y_continuous(labels = scales::comma)`

有关如何定制图表用于展示的更多内容，参见<a href="http://r4ds.had.co.nz/graphics-for-communication.html" target="_blank">http://r4ds.had.co.nz/graphics-for-communication.html</a>。

另见 ggplot2 文档网站<a href="https://ggplot2.tidyverse.org" target="_blank">https://ggplot2.tidyverse.org</a>。

假设我们在 “数据> 可视化” 中使用钻石数据创建了三组条形图。要在图表组上方添加标题并设置单列布局，可使用`patchwork`如下：

```r
library(patchwork)
plot_list <- visualize(
  diamonds,
  xvar = c("clarity", "cut", "color"),
  yvar = "price",
  type = "bar",
  custom = TRUE
)
wrap_plots(plot_list, ncol = 1) + plot_annotation(title = "Three bar plots")
```

有关如何定制图表组的更多信息，参见<a href="https://patchwork.data-imaginist.com">patchwork 文档网站</a>。

### 在 “报告> Rmd” 中制作交互式图表

使用`plotly`库可将 Radiant 中生成的（大多数）图表转换为交互式图形。设置`custom = TRUE`后，可使用`ggplotly`函数转换单个图表。见下方示例：

```r
visualize(diamonds, xvar = "price", custom = TRUE) %>%
  ggplotly() %>%
  render()
```

如果创建了多个图表，可使用`plotly`包的`subplot`函数。为`nrows`参数提供值以设置图表布局网格。在下方示例中创建了四个图表，由于`nrow = 2`，图表将以 2×2 网格显示。

```r
visualize(diamonds, xvar = c("carat", "clarity", "cut", "color"), custom = TRUE) %>%
  subplot(nrows = 2) %>%
  render()
```

有关`plotly`库的更多信息，参见下方链接：

* 入门指南：<a href="https://plot.ly/r/getting-started/" target="_blank">https://plot.ly/r/getting-started/</a>
* 参考手册：<a href="https://plot.ly/r/reference/" target="_blank">https://plot.ly/r/reference/</a>
* 书籍：<a href="https://cpsievert.github.io/plotly_book" target="_blank">https://cpsievert.github.io/plotly_book</a>
* 代码：<a href="https://github.com/ropensci/plotly" target="_blank">https://github.com/ropensci/plotly</a>

### R 函数

有关 Radiant 中用于数据可视化的相关 R 函数概述，请参见<a href = "  https://radiant-rstats.github.io/radiant.data/reference/index.html#section-data-visualize" target="_blank">“数据> 可视化”</a> 。
