> 确定测试样本数据计算出的均值或比例所需的样本量

### 示例 1

我们计划开展一家互联网服务提供商（ISP）业务，需要为商业计划和模型估计家庭一周的平均互联网使用时间。为了有 95% 的把握使样本均值在总体均值的 10 分钟范围内，我们必须随机选择多少户家庭？假设之前的家庭使用情况调查显示标准差为 60.95 分钟。

**答案：**

由于我们感兴趣的是估计总体中的平均（或均值）互联网使用时间，因此选择 “均值（Mean）” 的样本量计算。在下方截图中，我们输入 10（分钟）作为可接受误差，60.95 作为样本标准差的估计值，置信水平为 95%。

<p align="center"><img src="figures_design/sample_size_ex1a.png"></p>

如你所见，所需样本量为 143，即我们需要从目标总体中获得 143  份有效响应，才能在给定的可接受误差、置信水平和样本标准差下对总体均值进行推断。该数值假设发生率和响应率均为 1（或  100%）。假设我们市场中只有 75% 的家庭在家中接入互联网，且预期响应率为 20%，那么需要联系的家庭数量是多少？

<p align="center"><img src="figures_design/sample_size_ex1b.png"></p>

在上方截图中，发生率设为 75%，响应率设为 20%。所需有效响应数量与之前相同（143），但联系请求数量现在为 143÷0.75÷0.2 = 954。

<a   href="http://www.isixsigma.com/tools-templates/sampling-data/how-determine-sample-size-determining-sample-size/"  target="_blank">来源</a>

### 示例 2

假设你想调查某人群中 HIV 抗体的真实流行率是否为 10%。你计划随机抽样以估计该流行率，并希望有 95% 的置信度使总体真实比例落在根据样本计算的误差范围内。

假设总体规模为 5000，流行率的初始估计值为 10%，可接受误差为 4%。

**答案：**

由于我们想要估计目标人群中 HIV 抗体阳性者的比例，因此选择 “比例（Proportion）” 的样本量计算。在下方截图中，我们输入 4% 作为可接受误差，10% 作为比例（p）的初始估计值，置信水平为 95%。

<p align="center"><img src="figures_design/sample_size_ex2a.png"></p>

如你所见，所需样本量为 217，即我们需要 217 份有效响应，才能在给定的可接受误差和置信水平下对总体比例进行推断。该数值同样假设发生率和响应率为 100%。示例表明目标总体仅为 5000 人，因此可能值得应用总体规模校正。

<p align="center"><img src="figures_design/sample_size_ex2b.png"></p>

在上方截图中，我们点击 “是（Yes）” 以应用总体校正，然后输入 5000 作为总体规模。所需有效响应数量从 217 略微降至 208。

一般而言，当所需样本量（n）相对于总体规模（N）较大时，总体规模会对所需样本量产生显著影响。例如，如果总体仅为 250 人，校正后的样本量将为 117，而非 217。

<a   href="http://bphc.hrsa.gov/policiesregulations/performancemeasures/patientsurvey/calculating.html"  target="_blank">来源</a>

### 报告 > Rmd

通过点击屏幕左下角的<i title="report results" class="fa fa-edit"></i>图标或按键盘上的`ALT-enter`，向<a href="https://radiant-rstats.github.io/docs/data/report_rmd.html" target="_blank">*报告 > Rmd*</a>添加代码以（重新）创建样本量计算。

### 技术说明

#### 均值的样本量：

$$
  n = \frac{ z^2 \times s^2 }{ E^2 }
$$

其中n为样本量，z是与期望置信水平相关的 z 值（例如，95% 置信水平对应的 z 值为 1.96），s是样本标准差，E是可接受误差。即使你之前没见过上述公式，可能也记得置信区间的公式：

$$
  x \pm z \frac{s}{\sqrt{n}}
$$

xˉ两侧的区间等于E（即可接受误差）。两边平方并整理项可得样本量公式：

$$
  E = z \frac{s}{\sqrt{n}} \; \Rightarrow \; n = \frac{ z^2 \times s^2 }{ E^2 }
$$

#### 比例的样本量：

$$
  n = \frac{ z^2 \times p(1-p) }{ E^2 }
$$

其中n为样本量，z是与期望置信水平相关的 z 值（例如，95% 置信水平对应的 z 值为 1.96），p是样本比例，E是可接受误差。即使你之前没见过上述公式，可能也记得置信区间的公式：

$$
  p \pm z \sqrt{ \frac{p(1-p)}{n} }
$$

p两侧的区间等于E（即可接受误差）。两边平方并整理项可得样本量公式：

$$
  E = z \sqrt{ \frac{p(1-p)}{n} } \; \Rightarrow \; n = \frac{ z^2 p(1-p) }{ E^2 }
$$

#### 总体校正

虽然我们始终可以应用总体校正，但当所需样本量（n）相对于总体规模（N）较大时，总体规模才会对所需样本量产生显著影响。
$$
  n^* = \frac{ nN }{ n - 1 + N }
$$

例如，假设我们确定需要从 5000 人的总体中抽取 217 人的样本，那么经总体规模校正后的样本量（n∗）计算如下：

$$
  n^* = \frac{ 217 \times 5000 }{ 217 - 1 + 5000 } = 208
$$

### R 函数

有关 Radiant 中用于抽样和样本量计算的相关 R 函数概述，请参见<a href =  "https://radiant-rstats.github.io/radiant.design/reference/index.html#section-design-sample" target="_blank">*设计 > 样本*</a> 。
