> 汇总和探索你的数据

为数据中的一个或多个变量生成汇总统计量。“数据> 探索” 中最强大的功能是，你可以轻松地按一个或多个其他变量来描述数据。 <a href="https://radiant-rstats.github.io/docs/data/pivotr.html" target="_blank">_数据> 透视_</a> 标签页最适合生成频数表和汇总单个数值变量，而 “数据 > 探索” 标签页允许你使用各种统计量同时汇总多个变量。

例如，如果我们从`diamonds`数据集中选择`price`并点击 `生成表格` 按钮，就可以看到观测数（n）、均值、方差等统计量。此外，通过选择`clarity`作为 `分组变量`，也可以轻松获取每种钻石净度水平的平均价格。

> 注意，当分类变量（`factor`）从`数值变量` 下拉菜单中被选中时，若所选函数需要，该变量将被转换为数值变量。如果因子水平是数值型的，这些数值将用于所有计算。由于均值、标准差等统计量对非二元分类变量不适用，这类变量将被转换为 0-1（二元）变量，其中第一个水平编码为 1，其他所有水平编码为 0。

生成的汇总表格可以通过点击 “存储” 按钮存储到 Radiant 中。如果你想在 “数据 > 可视化” 中基于汇总数据创建图表，这会很有用。要将表格下载为 csv 格式，点击右上角的下载图标。

你可以从 `列标题` 下拉菜单中选择选项，切换不同的列标题。可选择  `应用函数`（如均值、中位数等）、`分组变量`（如价格、克拉等），或（首个）`分组依据`  变量的水平（如 Fair-Ideal）。

<p align="center"><img src="figures/explore.png"></p>

## 函数

以下是 `应用函数`下拉菜单中几个函数的简要说明。不过，大多数函数的含义不言自明。

* `n`计算数据中的观测数（或行数）；若选择了 “分组依据（Group by）” 变量，则计算每组中的观测数（`n`使用 R 中的`length`函数）
* `n_distinct`计算不同值的数量
* `n_missing`计算缺失值的数量
* `cv`是变异系数（即 mean (x) /sd (x)）
* `sd`和`var`计算数值数据的样本标准差和方差
* `me`使用 95% 置信水平计算数值变量的误差边际
* `prop`计算比例。对于仅含 0 或 1 值的变量，其结果等同于`mean`。对于其他数值变量，它计算最大值的出现比例。对于`factor`，它计算第一个水平的出现比例。
* `sdprop`和`varprop`计算比例的样本标准差和方差
* `meprop`使用 95% 置信水平计算比例的误差边际
* `sdpop`和`varpop`计算总体标准差和方差

### 过滤数据

使用 `过滤数据`框选择（或排除）数据中的特定行集。详见 `数据 > 查看` 的帮助文件。

### 报告 > Rmd

通过点击屏幕左下角的<i title="report results" class="fa fa-edit"></i>图标或按键盘上的`ALT-enter`，向<a href="https://radiant-rstats.github.io/docs/data/report_rmd.html" target="_blank">*报告 > Rmd*</a>添加代码以（重新）创建汇总表格。

### R 函数

有关 Radiant 中用于汇总和探索数据的相关 R 函数概述，请参见<a href = "  https://radiant-rstats.github.io/radiant.data/reference/index.html#section-data-explore" target="_blank">*数据 > 探索*</a> 。