% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulater.R
\name{simulater}
\alias{simulater}
\title{Simulate data for decision analysis}
\usage{
simulater(
  const = "",
  lnorm = "",
  norm = "",
  unif = "",
  discrete = "",
  binom = "",
  pois = "",
  sequ = "",
  grid = "",
  data = NULL,
  form = "",
  funcs = "",
  seed = NULL,
  nexact = FALSE,
  ncorr = NULL,
  name = "",
  nr = 1000,
  dataset = NULL,
  envir = parent.frame()
)
}
\arguments{
\item{const}{A character vector listing the constants to include in the analysis (e.g., c("cost = 3", "size = 4"))}

\item{lnorm}{A character vector listing the log-normally distributed random variables to include in the analysis (e.g., "demand 2000 1000" where the first number is the log-mean and the second is the log-standard deviation)}

\item{norm}{A character vector listing the normally distributed random variables to include in the analysis (e.g., "demand 2000 1000" where the first number is the mean and the second is the standard deviation)}

\item{unif}{A character vector listing the uniformly distributed random variables to include in the analysis (e.g., "demand 0 1" where the first number is the minimum value and the second is the maximum value)}

\item{discrete}{A character vector listing the random variables with a discrete distribution to include in the analysis (e.g., "price 5 8 .3 .7" where the first set of numbers are the values and the second set the probabilities}

\item{binom}{A character vector listing the random variables with a binomial distribution to include in the analysis (e.g., "crash 100 .01") where the first number is the number of trials and the second is the probability of success)}

\item{pois}{A character vector listing the random variables with a poisson distribution to include in the analysis (e.g., "demand 10") where the number is the lambda value (i.e., the average number of events or the event rate)}

\item{sequ}{A character vector listing the start and end for a sequence to include in the analysis (e.g., "trend 1 100 1"). The number of 'steps' is determined by the number of simulations}

\item{grid}{A character vector listing the start, end, and step for a set of sequences to include in the analysis (e.g., "trend 1 100 1"). The number of rows in the expanded will over ride the number of simulations}

\item{data}{Dataset to be used in the calculations}

\item{form}{A character vector with the formula to evaluate (e.g., "profit = demand * (price - cost)")}

\item{funcs}{A named list of user defined functions to apply to variables generated as part of the simulation}

\item{seed}{Optional seed used in simulation}

\item{nexact}{Logical to indicate if normally distributed random variables should be simulated to the exact specified values}

\item{ncorr}{A string of correlations used for normally distributed random variables. The number of values should be equal to one or to the number of combinations of variables simulated}

\item{name}{Deprecated argument}

\item{nr}{Number of simulations}

\item{dataset}{Data list from previous simulation. Used by repeater function}

\item{envir}{Environment to extract data from}
}
\value{
A data.frame with the simulated data
}
\description{
Simulate data for decision analysis
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/simulater.html} for an example in Radiant
}
\examples{
simulater(
  const = "cost 3",
  norm = "demand 2000 1000",
  discrete = "price 5 8 .3 .7",
  form = "profit = demand * (price - cost)",
  seed = 1234
) \%>\% str()

}
\seealso{
\code{\link{summary.simulater}} to summarize results

\code{\link{plot.simulater}} to plot results
}
