> 联合调查响应分析

要从头开始设置联合研究，我们需要确定应包含的属性和属性水平。完成后，通常需要生成联合轮廓的部分因子设计。这是为所选属性和水平生成的所有可能轮廓的子集（见<a href="https://radiant-rstats.github.io/docs/design/doe.html"  target="_blank">*设计 > DOE> 实验设计*</a>）。

一旦获得受访者的数据，就可以分析他们的评估结果，以确定部分价值（Part Worths, PW）和重要性权重（Importance Weights, IW）。

要估计模型，请选择受访者的评分（或排名）作为 “轮廓评估（Profile evaluations）”，并选择轮廓 “属性（Attributes）”。点击`Estimate`按钮或按`CTRL-enter`（Mac 上为`CMD-enter`）生成结果。

### 示例：地毯清洁剂

在一项联合研究中，向受访者展示了 18 个地毯清洁产品的轮廓，这些产品由 5 个属性描述。要获取`carpet`数据集，请前往 “数据> 管理”，从 “加载数据类型（Load data of type）” 下拉菜单中选择`Examples`，点击 “加载（Load）” 按钮，然后选择`carpet`数据集。

- `design` = 包装设计（A、B、C）
- `brand` = 品牌名称（K2R、Glory、Bissell）
- `price` = 价格（1.19 美元、1.39 美元、1.59 美元）
- `seal` = 《好管家》认证标志（有或无）
- `money_back` = 退款保证（有或无）
- `ranking` = 受访者对 18 个属性的排名

设计特征：

<p align="center"><img src="figures_multivariate/conjoint_carpet_design.png"></p>

基于这些属性，可创建 108 种可能的轮廓（即 3×3×3×2×2 = 108）。向受访者提供了 18 个轮廓，要求他们将这些轮廓从最偏好（排名 1）到最不偏好（排名 18）进行排序。前 5 列代表 5 个属性，最后一列是受访者的排名。

a. 计算属性变量的方差膨胀因子（VIF）。你注意到了什么？这关于呈现给受访者的 18 个轮廓集说明了什么？

下方显示的 VIF 值表明属性完全正交。在部分因子设计中，轮廓是经过特意选择的，因此所有属性都是不相关的。

		Multicollinearity diagnostics:
		    design brand price seal money_back
		VIF      1     1     1    1          1
		Rsq      0     0     0    0          0

b. 使用受访者的评估作为因变量，属性作为预测变量，估计联合模型。展示完整的部分价值和重要性权重列表。

<p align="center"><img src="figures_multivariate/conjoint_summary.png"></p>
<p align="center"><img src="figures_multivariate/conjoint_plot.png"></p>

c. 计算以下选项的预测效用：

* 包装 A、K2R 品牌、1.19 美元、无《好管家》认证、无退款保证
	- 基于部分价值的预测效用：6.5 + 0 + 0 + 0 + 0 + 0 = 6.5
* 包装 C、Bissell 品牌、1.19 美元、无《好管家》认证、有退款保证
	- 基于部分价值的预测效用：6.5 + 4.5 + 1.5 + 0 + 4.5 = 17
* 包装 B、Bissell 品牌、1.59 美元、有《好管家》认证、有退款保证
	- 基于部分价值的预测效用：6.5 + 8.0 + 1.5 - 7.67 + 1.5 + 4.5 = 14.33

d. 可获得的最高预测效用是多少？该选项的特征是什么？

*	具有最高（预测）效用的选项是：包装 B、Bissell 品牌、1.19 美元、有《好管家》认证、有退款保证
*	基于部分价值的预测效用：6.5 + 8.0 + 1.5 + 0 + 1.5 + 4.5 = 22

我们可以通过三个步骤验证这一结果：（1）在 “数据> 转换” 中使用 “扩展网格（Expand grid）” 创建包含所有 36  个轮廓的新数据集；（2）在 “多元分析 > 联合分析 > 预测（Predict）”  标签页中选择新创建的数据集，将预测结果存储在新变量`predict_ca`中；（3）在 “数据> 查看” 标签页中按`predict_ca`对新数据集排序。以下截图展示了这三个步骤：

#### 步骤 1：创建数据集

<p align="center"><img src="figures_multivariate/conjoint_expand.png"></p>

#### 步骤 2：预测效用

<p align="center"><img src="figures_multivariate/conjoint_predict.png"></p>

#### 步骤 3：排序预测结果

<p align="center"><img src="figures_multivariate/conjoint_view.png"></p>

## 多个受访者

如果有多个受访者的轮廓评估数据，且数据集中包含受访者 ID 变量，我们可以通过从 “分组依据（By）” 下拉菜单中选择受访者  ID，在个体层面估计联合分析结果。然后，我们可以将所有受访者的部分价值和 / 或重要性权重保存到 Radiant 的新数据集中，并使用  “多元分析> K 聚类” 进行细分。

### 报告 > Rmd

通过点击屏幕左下角的<i title="report results" class="fa fa-edit"></i>图标或按键盘上的`ALT-enter`，向<a href="https://radiant-rstats.github.io/docs/data/report_rmd.html" target="_blank">*报告 > Rmd*</a>添加代码以（重新）创建分析。

如果已创建图表，可使用`ggplot2`命令或`patchwork`进行自定义。详见下方示例和<a href="https://radiant-rstats.github.io/docs/data/visualize.html" target="_blank">*数据 > 可视化*</a>。

```r
plot(result, plots = c("pw", "iw"), custom = TRUE) %>%
   wrap_plots(plot_list, ncol = 2) + plot_annotation(title = "Conjoint Analysis")
```

### R 函数

有关 Radiant 中用于估计联合模型的相关 R 函数概述，请参见<a href =  "https://radiant-rstats.github.io/radiant.multivariate/reference/index.html#section-multivariate-conjoint" target="_blank">*多元分析> 联合分析*</a>。

`conjoint`工具中使用的核心函数包括`stats`包中的`lm`和`car`包中的`vif`。
