> 创建并评估用于决策分析的决策树

要创建并评估决策树，请先（1）在输入编辑器中输入树的结构，或（2）从文件加载树结构。首次导航到 “模型> 决策 > 决策分析”  标签页时，你会看到一个示例树结构。该结构基于 data.tree 库开发者 Christoph Glur 的一个<a  href="https://github.com/gluc/useR15/blob/master/00_data/jennylind.yaml" target="_blank">示例</a>，该库的地址为<a  href="https://github.com/gluc/data.tree" target="_blank">https://github.com/gluc/data.tree</a>。

要输入新结构，请先为树提供一个名称，并在 “Calculate” 按钮旁的输入框中输入标签。在下面的示例中，决策树的名称输入为：`name: Sign contract`。下一步是指定第一个节点的**类型**，选项为`type: decision`（决策型）或`type: chance`（机会型）。注意，我们暂时跳过`variables`部分，稍后再回到这部分内容。

在提供的示例中，第一个节点是**决策节点**。决策者必须决定 “与电影公司签约（Sign with Movie Company）” 还是 “与电视网签约（Sign with TV Network）”。第一个选项指向一个带有概率和收益的**机会**节点，第二个选项有固定收益。

> **注意：** 定义树结构时，缩进至关重要。如示例所示，使用制表符（tabs）创建分支。分支名称**必须**后跟一个冒号（`:`），且关于分支的信息**必须**使用制表符缩进。

在为决策 “与电影公司签约（Sign with Movie Company）” 提供名称后，下一行**必须**使用制表符缩进。在示例中，下一行开始描述机会节点（`type: chance`）。示例中有 3 种可能性：（1）“票房惨淡（Small Box Office）”、（2）“票房中等（Medium Box Office）”  和（3）“票房大卖（Large Box Office）”，每种情况都有相应的概率和收益。这些是树的一个分支的终点，通常称为  “终端节点（terminal nodes）” 或 “叶节点（leaves）”。所有终点都必须有`payoff`（收益）值。

> **注意：** 机会节点的概率之和应等于 1，且所有概率必须在 0 到 1 之间。

决策也可以分配`cost`（成本）。例如，如果我们决定与电影公司签约，可能需要支付 5000 美元的法律支持费用。假设与电视网的合同更简单，不需要法律协助。请注意，`costs`（成本）的使用是可选的。在示例中，我们也可以从每个可能的票房收益中减去 5000 美元。

如果树中的某些值相关或重复，使用`variables`（变量）部分会很有用。在这里，你可以为值分配标签、输入公式，甚至引用其他（子）树。注意，公式应仅引用`variables`部分中的条目，不能包含任何 R 命令。在 “签约（Sign contract）” 示例中，只创建了一个变量（即`legal fees`（法律费用））。“敏感性（Sensitivity）” 标签页要求树结构中包含`variables`部分。下面是 “签约” 示例的改编版本，它使用了更多变量和一个公式。


```yaml
name: Sign contract
variables:
    legal fees: 5000
    P(small): 0.3
    P(medium): 0.6
    P(large): 1 - P(small) - P(medium)
type: decision
Sign with Movie Company:
    cost: legal fees
    type: chance
    Small Box Office:
        p: P(small)
        payoff: 200000
    Medium Box Office:
        p: P(medium)
        payoff: 1000000
    Large Box Office:
        p: P(large)
        payoff: 3000000
Sign with TV Network:
    payoff: 900000
```

要引用另一个（子）树，请在`variables`部分使用`dtree`函数和（子）树的名称。例如，假设你想将一个评估周二定价决策的树（“tuesday_tree”）包含到评估周一定价决策的树中。`variables`部分的开头可能如下所示：

```yaml
variables:
  tuesday_emv: dtree("tuesday_tree")
```

然后，在周一的树中，你需要周二定价决策的 EMV 时，就可以引用`tuesday_emv`。

## 决策树输入规则

1. 始终以树名称开头（例如，`name: My tree`）
2. 第二行应开始`variables`部分或节点定义（即`type: chance`或`type: decision`）
3. 所有行都必须包含冒号（`:`）。对于节点名称，冒号位于行尾；对于其他所有行，冒号用于赋值，具体来说，它可以分配名称（例如`name: My tree`）、节点类型（例如`type: decision`）、变量（例如`legal fees: 5000`）或数值（例如`payoff: 100`、`p: 0.1`、`cost: 10`）
4. 节点类型后下一行必须是节点名称（例如`Cancel orders:`）
5. 节点名称中仅使用字母和空格（即不使用符号）
6. 节点名称后的行**必须**缩进
7. 终点（或终端节点、叶节点）必须有收益（例如`payoff: 100`）
8. 如果与机会节点关联，终端节点必须有概率（例如`p: 0.4`）和收益

在编辑器中指定树结构后，点击 “Calculate” 按钮，可在屏幕右侧看到文本格式的 “初始（Initial）” 和 “最终（Final）”  决策树（见下方截图）。初始树仅显示指定的树结构，以及节点类型、概率、成本和收益。最终树显示通过 “倒推（folding-back）”  树确定的最优决策策略。在这种情况下，最优决策是 “与电影公司签约（Sign with Movie Company）”，因为该决策具有更高的**预期货币价值（EMV）**。

<p align="center"><img src="figures_model/dtree_model.png"></p>

要查看决策树的可视化表示，请打开 “绘图（Plot）” 标签页。如果已在 “模型（Model）” 标签页中点击 “Calculate”  按钮，你将看到 “初始（Initial）” 决策树的图形（见下方截图）。决策节点显示为绿色，机会节点显示为橙色。如果树的外观与预期不符，请返回  “模型” 标签页编辑树结构。

<p align="center"><img src="figures_model/dtree_plot_initial.png"></p>

“最终（Final）” 图形显示通过 “倒推” 树确定的最优决策。最优决策是 “与电影公司签约”，因为该决策具有更高的**预期货币价值**。请注意，每个决策节点的最优决策通过连接到节点的较粗线条显示。

<p align="center"><img src="figures_model/dtree_plot_final.png"></p>

“与电视网签约” 的 EMV 为 900,000 美元。如果忽略成本，“与电影公司签约” 的预期收益为：

$$
  0.3 \times 200,000 + 0.6 \times 1,000,000 + 0.1 \times 3000,000 = 960,000
$$

但由于我们需支付 5,000 美元的法律费用，与电影公司签约的 EMV 为 960,000 - 5,000 = 955,000  美元。将光标悬停在屏幕上显示的机会节点上，可看到显示计算过程的 “提示框（tooltip）”。为突出显示已指定  “成本（cost）”，图中的机会节点有虚线外框。

在 “签约” 示例中，显然 “与电影公司签约” 是首选方案。但是，假设该方案的法律费用为 10,000 美元或 30,000  美元，我们还会选择相同的方案吗？这就是 “敏感性（Sensitivity）” 标签页的用处。在这里，我们可以评估如果法律费用变化，决策（如  “与电影公司签约” 和 “与电视网签约”）会如何变化。输入 0 作为 “最小值（Min）”、80000 作为 “最大值（Max  value）”、10000 作为 “步长（Step）”，然后点击<i class="fa  fa-plus"></i>图标。点击 “评估敏感性（Evaluate sensitivity）”  后，将显示一个图形，说明各决策的收益如何变化。注意，当法律费用高于 60,000 美元时，“与电视网签约” 产生最高的 EMV。

<p align="center"><img src="figures_model/dtree_sensitivity.png"></p>

## 视频教程

将以下完整命令复制粘贴到 RStudio 控制台（即左下角窗口），按回车即可获取 Radiant 教程系列中决策树模块使用的所有材料：

<pre>usethis::use_course("https://www.dropbox.com/sh/bit4p1ffbkb2dgh/AACm1RVy2BxBDiVbjoLiN5_Ea?dl=1")</pre>

<a href="https://youtu.be/plSeVJ7c-Iw" target="_blank">决策分析入门（一）</a>

- 本视频带你逐步了解手动构建和求解基本决策树的必要步骤
- 主题列表：
  - 机会节点与决策节点
  - 树的倒推（即从最右侧节点开始，向左逐步倒推到最左侧节点）

<a href="https://youtu.be/dBySH3z2Paw" target="_blank">使用 Radiant 构建决策树（二）</a>

- 本视频演示如何在 Radiant 中构建基本决策树
- 主题列表：
  - 重命名树文件
  - 构建树（遵循决策树输入规则）
  - 解释结果（初始树与最终树）
  - 保存决策树输入.yaml 文件

<a href="https://youtu.be/NlvWCU8UhTc" target="_blank">如何将决策树结果写入报告（三）</a>

- 本视频演示如何在 Radiant 中构建基本决策树并将生成的 R 代码添加到报告中
- 主题列表：
  - 构建决策树并在决策树中定义变量
  - 向报告添加多个树
  - 演示一些有用的键盘快捷键
  - 保存 Radiant 状态文件和报告

<a href="https://youtu.be/c_pCCCn6FEw" target="_blank">决策树的敏感性分析（四）</a>

- 本视频展示在 Radiant 中对决策树进行敏感性分析的两种方法
- 主题列表：
  - 快速回顾将决策树结果写入报告
  - 方法一：手动更新值
  - 方法二：使用 “variables”

<a href="https://youtu.be/oiwv15bbjzs" target="_blank">如何调试决策树输入（五）</a>

- 本视频演示如果收到错误消息，如何调试决策树输入
- 主题列表：
  - 缺少冒号
  - 缩进问题
  - 概率之和不等于 1
  - 值缺失

<a href="https://youtu.be/xuv9zgAcvCQ" target="_blank">含不完全信息的决策树（六）</a>

- 本视频展示当可用信息不完全时，如何确定决策树中使用的适当（条件）概率
- 主题列表：
  - 不完全信息
  - 测试
  - 条件概率

<a href="https://youtu.be/cVrYFFX3xN0" target="_blank">求解含不完全信息的决策树（七）</a>

- 本视频展示当可用信息不完全时，如何使用 Radiant 构建和求解决策树
- 主题列表：
  - 指定变量
  - 构建含不完全信息的树
  - 检查树
  - 解释决策树结果

<a href="https://youtu.be/Mi-eZEoU9TE" target="_blank">在 Radiant 中构建含子树的决策树（八）</a>

- 本视频展示如何在 Radiant 中构建含子树的决策树
- 主题列表：
  - 创建引用子树的主树
  - 指定在变量部分引用主树的子树

完整的 “Radiant 教程系列” 见以下链接：

<a href="https://www.youtube.com/playlist?list=PLNhtaetb48EdKRIY7MewCyvb_1x7dV3xw" target="_blank">https://www.youtube.com/playlist?list=PLNhtaetb48EdKRIY7MewCyvb_1x7dV3xw</a>

## 按钮

在 “模型（Model）” 标签页中：

* 要查看本帮助文件，点击<i class="fa fa-question"></i>图标
* 要在 “报告> Rmd” 标签页中生成关于决策树的报告，点击<i class="fa fa-edit"></i>图标或按键盘上的`ALT-enter`
* 选择最大化（`Max`）或最小化（`Min`）收益。注意，收益可以为负数
* 点击 “Calculate” 按钮或按`CTRL-enter`（Mac 上为`CMD-enter`）生成或更新结果
* 在 “Calculate” 按钮旁的文本输入框中指定决策树的名称。点击 “Calculate” 按钮将保存你的设置。如果有多个树结构可用，还会出现一个下拉菜单，你可以选择要使用的结构，以及一个 “Remove” 按钮来删除树结构
* 要将编辑器窗口中输入的树结构保存到磁盘，按 “Save input” 按钮
* 要将初始树和最终树的文本表示保存到文件，点击 “Save output” 按钮
* 要从 yaml 格式的文件加载树结构，点击 “Choose File” 按钮

在 “绘图（Plot）” 标签页中：

- 要查看本帮助文件，点击<i class="fa fa-question"></i>图标
- 要在 “报告> Rmd” 标签页中生成关于决策树的报告，点击<i class="fa fa-edit"></i>图标或按键盘上的`ALT-enter`
- 显示 “初始（Initial）” 或 “最终（Final）” 决策树
- 点击 “Calculate” 按钮或按`CTRL-enter`（Mac 上为`CMD-enter`）生成或更新结果
- 输入绘图中显示的小数位数（默认收益为 2 位，概率为 4 位）
- 提供用于收益的符号（例如 $ 或 RMB）
- 点击浏览器右上角的下载图标，将初始或最终绘图下载为 png 文件

目前无法直接为 “决策树（Decision Tree）” 图添加标题或说明文字。

在 “敏感性（Sensitivity）” 标签页中：

* 要查看本帮助文件，点击<i class="fa fa-question"></i>图标
* 要在 “报告> Rmd” 标签页中生成关于决策树的报告，点击<i class="fa fa-edit"></i>图标或按键盘上的`ALT-enter`
* 选择一个或多个 “要评估的决策（Decisions to evaluate）”
* 在 “对以下变化的敏感性（Sensitivity to changes in）” 中选择变量。这些变量必须在 “模型” 标签页的决策树结构的`variables`部分中定义
* 为所选变量输入最小值、最大值和步长，然后点击<i class="fa fa-plus"></i>图标
* 点击 “评估敏感性（Evaluate sensitivity）” 或按`CTRL-enter`（Mac 上为`CMD-enter`）生成结果和绘图
* 点击浏览器右上角的下载图标，将绘图下载为 png 文件

如果已创建敏感性绘图，可使用`ggplot2`命令对其进行自定义（见下方示例）。详情请参见<a href="https://radiant-rstats.github.io/docs/data/visualize.html" target="_blank">*数据 > 可视化*</a>。

```r
sensitivity(
  result, 
  vars = "legal fees 0 100000 1000;", 
  decs = c("Sign with Movie Company", "Sign with TV Network"), 
  custom = TRUE
) + labs(caption = "Based on example created by ...")
```

## 决策树编辑器

实用的键盘快捷键：

* 注释当前行或所选行（Windows：Ctrl-/ Mac：Cmd-/）
* 折叠所有行（Windows：Alt-0 Mac：Alt-Cmd-0）
* 展开所有行（Windows：Shift-Alt-0 Mac：Shift-Alt-Cmd-0）
* 搜索（Windows：Ctrl-f Mac：Cmd-f）
* 搜索并替换（Windows：Ctrl-f-f Mac：Cmd-f-f）
* 撤销编辑（Windows：Ctrl-z Mac：Cmd-z）
* 重做编辑（Windows：Shift-Ctrl-z Mac：Shift-Cmd-z）

你也可以使用行号旁的小三角形折叠 / 展开行。

更多快捷键见：

<a href="https://github.com/ajaxorg/ace/wiki/Default-Keyboard-Shortcuts" target="_blank">https://github.com/ajaxorg/ace/wiki/Default-Keyboard-Shortcuts</a>

### R 函数

有关 Radiant 中用于决策分析的相关 R 函数概述，请参见<a href =  "https://radiant-rstats.github.io/radiant.model/reference/index.html#section-model-decision-analysis" target="_blank">*模型 > 决策分析*</a>。

`dtree`工具中使用的来自`data.tree`包的核心元素是`as.Node`函数以及`Get`和`Do`方法。
