> 大模型生成描述性统计（指标）

## 使用方法

以下是 `大模型生成描述性统计`的使用方法。

1.`数据对象`必须要有，且必须和数据集中的名字一致（大小写也一致）

2.`统计方法`必须要有，比如t检验、卡方检验等。

3.`生成代码`如果有误，或者想要修改，可以点击`编辑`按钮对R代码进行修改，保存后点击`运行`按钮即可。

## 示例

**1. 单变量推断**

- 对 `age` 进行单样本 t 检验，原假设总体均值为 35。

- 检验 `bmi` 的平均值是否显著高于 25（单侧 t 检验）。

**2. 两组比较**

- 比较 `smoker` = "yes" 和 "no" 两组的 `charges` 均值差异（独立样本 t 检验）。
- 使用 Wilcoxon 秩和检验，比较男性与女性（`sex`）的 `bmi` 中位数是否不同。

**3.分类变量关联**

- 执行卡方独立性检验，判断 `sex` 与 `smoker` 是否相关。
- 分析 `region` 和 `smoker` 的列联表，进行卡方检验。

**4.多组比较**

- 对 `charges` 按 `region` 分组进行单因素方差分析（one-way ANOVA）。
- 使用 Kruskal-Wallis 检验，比较不同 `children` 数量（0~5）对应的 `charges` 分布差异。

**5.相关与回归**

- 计算 `age` 与 `charges` 的 Pearson 相关系数并检验显著性。
- 拟合线性回归模型、以 `charges` 为因变量，`age`、`bmi`、`children` 和 `smoker` 为自变量。
- 在控制 `age` 和 `bmi` 的情况下，检验 `smoker` 对 `charges` 的偏回归系数是否显著（多元线性回归）。

**6.交互效应**

- 通过双因素方差分析，检验 `smoker` 与 `sex` 对 `charges` 是否存在交互作用。