> 基于（不）相似性数据的感知图可通过多维尺度分析（MDS）进行研究

### 示例 1

城市数据（`city`）包含美国 10 个主要城市之间以英里为单位的距离信息，提供了 45 对（10×9/2）出发 - 到达城市对的距离。这些数据用于说明 MDS 可利用简单的距离数据（或我们将看到的品牌不相似性数据）创建二维地图，准确呈现城市（或品牌）的相对位置。

要加载`city`数据，前往 “数据> 管理”，从 “加载数据类型（Load data of type）” 下拉菜单中选择`examples`，点击 “加载（Load）” 按钮，然后选择`city`数据集。在 “多元分析> 感知图 > （不）相似性分析” 中，选择`from`作为 ID 1，`to`作为 ID 2，`distance`作为不相似性度量。更改设置后，点击 “估计模型（Estimate model）” 按钮或按`CTRL-enter`（macOS 上为`CMD-enter`）生成结果。

原始距离以（下三角）矩阵形式显示在下方截图中。如果分析成功，我们预期距离近的城市（如华盛顿特区和纽约）在地图上的位置也较近，而距离远的城市（如西雅图和迈阿密）在地图上的位置也应较远。

MDS 的基本（不）拟合度量称为 “应力值（Stress）”。如果 MDS 无法创建准确描述原始数据的地图，会导致高应力值。应力值为 0.1  通常被认为尚可，0.05 为良好，0.01 或更低为极佳。高应力值表明需要三维（或更高维）才能准确呈现数据。城市数据的应力值为  0.02，属于良好。在 “摘要（Summary）” 标签页中，我们还能看到用于创建 “绘图（Plot）”  标签页中二维地图的坐标，以及还原的距离（即生成的地图中城市之间的 “距离”）。

<p align="center"><img src="figures_multivariate/mds_summary.png"></p>

在下方 “绘图” 标签页的截图中，洛杉矶、波士顿等城市的相对位置看起来有误。这是因为 MDS 程序没有南北东西的信息。我们可以 “翻转（flip）” 图表，看看地图是否更容易识别和解释。

<p align="center"><img src="figures_multivariate/mds_plot.png"></p>

要创建下方所示图表，勾选 “维度 1（dimension 1）” 和 “维度 2（dimension 2）” 的复选框。沿水平轴和垂直轴翻转图表后，我们看到城市的相对位置相当准确。注意，此地图是 “平面的”，即未校正地球曲率。

<p align="center"><img src="figures_multivariate/mds_plot_flip.png"></p>

### 示例 2

下图基于一组牙膏品牌的相似性数据（`tpbrands`是示例数据集之一）。研究人员向受访者提出以下问题：“请根据相似性对以下每对牙膏品牌进行评分（1 = 非常相似，7 = 非常不相似）”，涉及 10 个品牌的所有成对组合，共 45 组比较。MDS 将尝试创建地图，尽可能准确地还原 50  名受访者提供的原始不相似性（或感知距离）。原始不相似性评分以（下三角）矩阵形式显示在下方图表中。从这些数据中我们已能看出，受访者认为某些品牌非常相似（如 Ultra Brite 和 Pepsodent 的平均不相似性得分为 1.11），而其他品牌则非常不相似（如 Crest 和  Sensodyne）。二维解决方案的应力值较为合理（0.058）。但正如预期，原始距离与还原距离的拟合度不如`city`数据。

<p align="center"><img src="figures_multivariate/mds_summary_tpbrands.png"></p>

“摘要” 标签页中显示的坐标用于在 “绘图” 标签页中以二维方式绘制品牌。在图表中，Aqua Fresh 与 Colgate、Ultra Brite 与 Pepsodent 的位置非常接近，这与原始数据一致。而 Sensodyne 和 Crest 则位于图表的两端，这也与原始数据一致，直观证实了 MDS 能够创建与数据拟合度较好的图表。

管理者从图表中可能会得出结论：地图上位置最接近的品牌被消费者视为密切替代品，因此在该细分市场的消费者心中是直接竞争对手。相反，Aqua Fresh 或 Macleans 的管理者在制定品牌竞争性定位计划时，可能较少关注  Sensodyne。基于（不）相似性数据的品牌地图的一个重要局限性是坐标轴难以解释。例如，为何 Close-up 和 Crest  沿水平轴位于两端？研究人员可要求受访者解释坐标轴的含义，或获取品牌的额外属性信息，将其与图表关联 /  叠加以辅助解释。不过，此类属性数据也可用于创建品牌地图，而无需（不）相似性评分（见 “多元分析> 感知图 > 属性分析”）。

<p align="center"><img src="figures_multivariate/mds_plot_tpbrands.png"></p>

### 报告 > Rmd

通过点击屏幕左下角的<i title="report results" class="fa fa-edit"></i>图标或按键盘上的`ALT-enter`，向<a href="https://radiant-rstats.github.io/docs/data/report_rmd.html" target="_blank">*报告 > Rmd*</a>添加代码以（重新）创建分析。

### R 函数

有关 Radiant 中用于生成品牌地图的相关 R 函数概述，请参见<a href =  "https://radiant-rstats.github.io/radiant.multivariate/reference/index.html#section-multivariate-maps" target="_blank">*多元分析 > 感知图*</a>。

`mds`工具中使用的核心函数包括`stats`包中的`cmdscale`和`MASS`包中的`isoMDS`。
