% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goodness.R
\name{summary.goodness}
\alias{summary.goodness}
\title{Summary method for the goodness function}
\usage{
\method{summary}{goodness}(object, check = "", dec = 2, ...)
}
\arguments{
\item{object}{Return value from \code{\link{goodness}}}

\item{check}{Show table(s) for the selected variable (var). "observed" for the observed frequencies table, "expected" for the expected frequencies table (i.e., frequencies that would be expected if the null hypothesis holds), "chi_sq" for the contribution to the overall chi-squared statistic for each cell (i.e., (o - e)^2 / e), "dev_std" for the standardized differences between the observed and expected frequencies (i.e., (o - e) / sqrt(e)), and "dev_perc" for the percentage difference between the observed and expected frequencies (i.e., (o - e) / e)}

\item{dec}{Number of decimals to show}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Summary method for the goodness function
}
\details{
See \url{https://radiant-rstats.github.io/docs/basics/goodness} for an example in Radiant
}
\examples{
result <- goodness(newspaper, "Income", c(.3, .7))
summary(result, check = c("observed", "expected", "chi_sq"))
goodness(newspaper, "Income", c(1 / 3, 2 / 3)) \%>\% summary("observed")

}
\seealso{
\code{\link{goodness}} to calculate results

\code{\link{plot.goodness}} to plot results
}
