> 一键生成描述性统计

## 函数

以下是 `应用函数`中每个函数的简要说明。

* `样本量（n_obs）`表示所分析变量中非缺失值的总个数，直观告诉你当前统计基于多少条原始记录，是任何后续计算的分母与可信度基础。
* `缺失值数（n_missing）`统计该变量中 NA 的个数，帮助你快速评估数据完整性与潜在偏差，缺失越多越需要审视数据采集或清洗环节。
* `唯一值数（n_distinct）`计数变量中不同取值的个数，可初步判断数据是连续、离散还是近似常数，对后续选择分组或可视化方式起关键提示。
* `均值（mean）`所有非缺失值之和除以个数，反映数据的重心位置，易受极端值拉动，可作为整体水平的“标杆”，但对偏斜分布需结合中位数等补充。
* `中位数（median）`将非缺失值排序后处于中间位置的数，把数据平分为两半，对极端值不敏感，常被用作偏斜分布的“稳健中心”。
* `众数（modal）`出现次数最多的值，类别变量中可直接看出最常出现的类别，连续变量中可揭示潜在峰值或数据录入中的默认值。
* `最小值（min）`所有非缺失值中的最小观测，用于发现异常低值、检测量表下限或评估测量范围。
* `最大值（max）`所有非缺失值中的最大观测，用于发现异常高值、检测量表上限或评估测量范围。
* `总和（sum）`非缺失值的简单累加，常在数量级、总量估计或后续比率计算中直接使用，但须注意量纲与单位。
* `方差（var）`衡量数据围绕均值的离散程度，平方单位放大了离群值的影响，是构建置信区间与假设检验的核心要素。
* `标准差（sd）`方差的平方根，与原始数据同量纲，直观表示“平均离均距离”，在正态假设下可用来构建经验法则区间。
* `标准误（se）`样本均值的标准差，反映用当前样本估计总体均值时可能产生的抽样误差，随样本量增大而减小。
* `误差边际（me）`在指定置信水平下，估计值与真实参数之间可能的最大绝对差距，常用于报告“估计值 ± 误差”形式。
* `变异系数（cv）`标准差与均值的比值，以百分比或无量纲形式衡量相对波动，适用于量纲不同或均值差异大的变量比较。
* `比例（prop）`针对二元或类别变量，计算某一类别占比，直接回答“有多少比例符合某条件”的业务问题。
* `比例方差（varprop）`比例估计量的方差，用于衡量比例的不确定度，是构建比例置信区间的必要中间量。
* `比例标准差（sdprop）`比例方差的平方根，与比例同量纲，方便解释比例估计的波动大小。
* `比例标准误（seprop）`比例估计量的标准误，随样本量增加而减小，用于比例区间估计和假设检验。
* `比例误差边际（meprop）`比例估计在置信水平下的最大误差范围，可直接加到比例上给出上下置信限。
* `总体方差（varpop）`使用总体分母 N 而非样本 n-1 计算的方差，适用于已知总体或加权场景，数值略小于样本方差。
* `总体标准差（sdpop）`总体方差的平方根，用于需要总体参数而非样本推断的场合，例如完整普查数据。
* `1%分位数（p01）`小于该值的数据占1%，可检测极端低值或建立尾部阈值，常用于质量控制或异常检测。
* `2.5%分位数（p025）`小于该值的数据占2.5%，用于构建95%双侧置信区间的下限或识别极端左尾。
* `5%分位数（p05）`小于该值的数据占5%，可作为稳健下限或风险度量中的“最坏5%”阈值。
* `10%分位数（p10）`小于该值的数据占10%，用于稳健范围划定或早期预警线。
* `25%分位数（p25）`第一四分位数，把最低25%的数据与剩余部分分开，常用于箱线图下须计算与离群点判定。
* `75%分位数（p75）`第三四分位数，把最低75%的数据与最高25%分开，与 p25 共同构建 IQR 评估中间50%的离散。
* `90%分位数（p90）`高于该值的数据占10%，在风险管理中表示“极端高值”门槛，也可用于目标设定。
* `95%分位数（p95）`高于该值的数据占5%，常用于工程规格上限或质量控制的警戒值。
* `97.5%分位数（p975）`用于构建95%双侧置信区间的上限或检测极端右尾。
* `99%分位数（p99）`高于该值的数据仅占1%，被视为极端值分界线，适合异常检测或设置高安全阈值。
* `偏度（skew）`刻画数据分布的不对称程度：正值表示右尾更长，负值表示左尾更长，0 左右近似对称，影响均值与中位数差异及后续模型选择。
* `峰度（kurtosi）`描述分布尾部厚度和峰值陡峭程度，高峰度意味着极端值概率更高，低峰度分布更平坦，对风险估计和稳健统计意义重大。
* `四分位距（IQR）`p75 与 p25 的差值，代表中间50%数据的离散范围，不受极端值影响，是箱线图的核心指标之一。

## 图表
### 1.分布图（dist） 

**定义与用途**： 

- 分布图主要用于展示**单个连续变量**的分布情况
- 本质上是一种**直方图**（histogram），通过将数据分成多个区间（bins）并显示每个区间内观测值的数量
- 适用于了解数据的集中趋势、离散程度和分布形状

**特点**： 

- 可以通过`bins`参数调整分箱数量（默认10个，范围1-50）
- 支持"密度"选项（Density），将纵轴从计数转换为概率密度
- 可以使用"Log X"选项对X轴进行对数变换
- 支持填充颜色（fill）和透明度（alpha）调整

**适用场景**： 

- 检查变量是否符合正态分布
- 识别数据中的异常值
- 比较不同组别数据的分布差异（通过分面或填充）

**注意事项**： 

- 仅适用于连续变量
- 分布形状受分箱数量影响，需要适当调整
- 当数据量很大时，可能需要限制显示的数据点数量

### 2.密度图（density） 

**定义与用途**： 

- 密度图是分布图的平滑版本，用于估计**概率密度函数**
- 使用核密度估计（Kernel Density Estimation）方法创建平滑曲线
- 适用于展示单个连续变量的概率分布

**特点**： 

- 使用`smooth`参数控制平滑度（范围0.1-3.0）
- 比直方图更少受分箱选择的影响
- 可以叠加多个密度曲线进行比较
- 支持"Log X"选项对X轴进行对数变换

**适用场景**： 

- 比较不同组别数据的分布形状
- 展示数据的概率分布特征
- 当样本量较大时，提供比直方图更平滑的分布表示

**注意事项**： 

- 过度平滑可能掩盖数据的真实特征
- 适用于连续变量，不适用于分类变量
- 在多模态分布中，可能需要调整平滑参数以显示所有峰值

### 3.散点图（scatter） 

**定义与用途**： 

- 散点图用于展示**两个连续变量**之间的关系
- 每个点代表一个观测值，X和Y坐标分别表示两个变量的值
- 是探索变量间相关性和模式的基本工具

**特点**： 

- 支持添加回归线（"Line"选项）
- 支持添加局部加权回归线（"Loess"选项，通过smooth参数控制）
- 支持抖动（"Jitter"选项），解决离散变量重叠问题
- 可以使用颜色（color）、填充（fill）和大小（size）编码额外变量
- 可以限制显示的数据点数量（nrobs参数）

**适用场景**： 

- 探索两个变量之间的相关性
- 识别异常值和数据模式
- 展示三个或更多变量的关系（通过颜色、大小等视觉编码）

**注意事项**： 

- 当数据量极大时，可能会出现过度重叠，需要限制点数或使用抖动
- 不适合展示分类变量与连续变量的关系（应使用箱线图等）
- 需要谨慎解释相关性与因果关系

### 4.曲面图（surface） 

**定义与用途**： 

- 曲面图用于展示**三个变量**之间的关系
- 两个变量作为X和Y轴，第三个变量作为高度（Z轴）
- 本质上是三维数据的二维表示，通常使用颜色或等高线表示高度

**特点**： 

- 严格要求恰好两个X变量
- 使用颜色梯度表示Z值的大小
- 适用于连续变量之间的关系
- 可以视为散点图在三维空间的扩展

**适用场景**： 

- 展示响应曲面（如实验设计中的响应面分析）
- 可视化两个自变量对一个因变量的联合影响
- 展示地理数据中的高程或温度分布

**注意事项**： 

- 需要恰好两个X变量，否则会报错
- 仅适用于三个连续变量
- 在二维平面上表示三维数据可能造成视觉扭曲
- 数据量较大时可能渲染缓慢

### 5.折线图（line） 

**定义与用途**： 

- 折线图通过连接数据点的线段展示变量随另一个变量（通常是时间）的变化趋势
- 适用于展示连续变化的数据，尤其是时间序列数据

**特点**： 

- 通常只允许一个X变量
- 支持使用颜色（color）区分多个Y变量
- 可以组合多个Y变量在同一图表中（通过"Combine Y-variables"选项）
- 支持"Log X"和"Log Y"对数坐标轴

**适用场景**： 

- 展示时间序列数据的趋势和模式
- 比较多个变量随时间的变化
- 显示连续变量之间的函数关系

**注意事项**： 

- 仅适用于有序数据（特别是时间序列）
- 不适合展示分类变量之间的关系
- 当数据点过多时，线条可能过于复杂难以解读
- 需要确保X轴变量是有序的，否则折线可能产生误导

### 6.条形图（bar） 

**定义与用途**： 

- 条形图使用矩形条的高度表示分类变量的值
- 可以是垂直的（柱状图）或水平的（条形图）
- 适用于比较不同类别之间的数值大小

**特点**： 

- 通常只允许一个X变量（分类变量）
- 支持使用函数（fun）指定汇总方式（如mean、median）
- 可以使用填充（fill）按子类别分组
- 支持"Flip"选项交换X和Y轴

**适用场景**： 

- 比较不同类别的计数或汇总统计量
- 展示分类变量的分布
- 比较多个组别在某个指标上的表现

**注意事项**： 

- X变量应为分类变量（factor）
- 不适合展示连续变量的详细分布
- 当类别过多时，条形可能过于拥挤
- 需要谨慎选择汇总函数（如mean可能受异常值影响）

### 7.箱线图（box） 

**定义与用途**： 

- 箱线图（盒须图）展示数据的五数概括：最小值、第一四分位数（Q1）、中位数、第三四分位数（Q3）和最大值
- 用于比较不同组别数据的分布特征和识别异常值

**特点**： 

- X变量通常为分类变量，Y变量为连续变量
- 箱体表示中间50%的数据（IQR，四分位距）
- 须线通常延伸到1.5倍IQR范围内的最远点
- 超出须线的点被视为潜在异常值
- 支持抖动（"Jitter"选项）显示原始数据点

**适用场景**： 

- 比较多个组别数据的中心趋势和离散程度
- 识别数据中的异常值
- 检查数据的对称性和偏态
- 比较不同条件下响应变量的分布

**注意事项**： 

- Y变量应为连续变量，X变量应为分类变量
- 无法显示数据分布的具体形状（如双峰分布）
- 当样本量很小时，箱线图可能不准确
- 需要结合其他图表（如散点图）获取更完整的数据视图