> 估计用于分类的逻辑回归

### 功能说明

要估计逻辑回归模型，我们需要一个二元响应变量和一个或多个解释变量。我们还需要指定响应变量中被视为 “成功事件” 的水平（即 “选择水平（Choose level:）” 下拉菜单）。在示例数据集`titanic`中，变量`survived`的成功水平为`Yes`（存活）。

要获取该数据集，请前往 “数据> 管理”，从 “加载数据类型（Load data of type）” 下拉菜单中选择`examples`，然后点击 “加载（Load）” 按钮，接着选择`titanic`数据集。

在 “摘要（Summary）” 标签页中，我们可以通过在 “待检验变量（Variables to test）”  下拉菜单中选择变量，来检验两个或多个变量是否共同对模型拟合有显著贡献。此功能对于检验因子（factor）类型变量的整体影响是否具有统计显著性非常有用。

需要重新估计的额外输出：

* 标准化（Standardize）：如果解释变量的测量尺度不同，优势比（Odds-ratios）可能难以比较。通过在估计前对解释变量进行标准化，我们可以看出哪些变量的影响更大。Radiant 中对逻辑回归数据的标准化方法是将所有解释变量X替换为(X−mean(X))/(2×sd(X))。详见<a  href="http://www.stat.columbia.edu/~gelman/research/published/standardizing7.pdf" target="_blank">Gelman 2008</a>的讨论。
* 中心化（Center）：将所有解释变量X替换为X−mean(X)。这在解释交互效应时可能有用。
* 逐步回归（Stepwise）：一种数据挖掘方法，用于选择拟合效果最佳的模型。使用时需谨慎！
* 稳健标准误（Robust standard errors）：选择 “稳健（robust）” 后，系数估计值与普通逻辑回归相同，但标准误会进行调整。当估计中指定概率权重时，默认使用此调整。

无需重新估计的额外输出：

- VIF：方差膨胀因子（Variance Inflation Factors）和 R 平方（Rsq），这些是解释变量间多重共线性的度量指标。
- 置信区间（Confidence intervals）：系数的置信区间。
- 优势比（Odds）：带置信区间的优势比。

### 示例 1：泰坦尼克号生存情况

我们以描述泰坦尼克号乘客生存状态的数据集为例。泰坦尼克号乘客数据的主要来源是《泰坦尼克号百科全书》。原始来源之一是 Eaton & Haas（1994）的《Titanic: Triumph and Tragedy》（Patrick Stephens  Ltd 出版），其中包含由多位研究者编制并经 Michael A. Findlay  编辑的乘客名单。假设我们想研究哪些因素与泰坦尼克号沉没时的生存概率密切相关。我们重点关注数据中的四个变量：

- `survived`：因子变量，水平为`Yes`（存活）和`No`（未存活）
- `pclass`：乘客等级（1st、2nd、3rd），作为社会经济地位（SES）的替代指标（1st≈上层；2nd≈中层；3rd≈下层）
- `sex`：性别（female 女性、male 男性）
- `age`：年龄（岁）

选择`survived`作为响应变量，并在 “选择水平（Choose level）” 中选择`Yes`。选择`pclass`、`sex`和`age`作为解释变量。在下方截图中，我们看到每个系数都具有统计显著性（p 值 <0.05），且模型具有一定的预测能力（卡方统计量 < 0.05）。遗憾的是，逻辑回归模型的系数难以直接解释。“OR”  列提供了估计的优势比。我们发现，与一等舱乘客相比，二等舱和三等舱乘客的生存优势显著更低；男性的生存优势也低于女性。虽然年龄的影响在统计上显著，但每增加 1 岁，生存优势的变化并不强烈（另见标准化系数）。

对于每个解释变量，可针对优势比提出以下原假设和备择假设：

* H0：解释变量 x 相关的优势比等于 1
* Ha：解释变量 x 相关的优势比不等于 1

逻辑回归的优势比可解释如下：

- 在模型中其他变量保持不变的情况下，与一等舱乘客相比，二等舱乘客的生存优势低 72%。
- 在模型中其他变量保持不变的情况下，与一等舱乘客相比，三等舱乘客的生存优势低 89.8%。
- 在模型中其他变量保持不变的情况下，与女性乘客相比，男性乘客的生存优势低 91.7%。
- 在模型中其他变量保持不变的情况下，乘客年龄每增加 1 岁，生存优势下降 3.4%。

<p align="center"><img src="figures_model/logistic_summary.png"></p>

除了 “摘要” 标签页中的数值输出外，我们还可以可视化评估生存状态（`survival`）与等级（`class`）、性别（`sex`）和年龄（`age`）之间的关系（见 “绘图（Plot）” 标签页）。在下方截图中，我们看到带有置信区间的系数（更准确地说是优势比）图。性别和等级相对于年龄的重要性明显突出。注意：在 “摘要” 标签页中勾选标准化系数（`standardize`），看看结论是否会改变。

<p align="center"><img src="figures_model/logistic_plot.png"></p>

概率通常比逻辑回归模型的系数或优势比更便于解释。我们可以使用 “预测（Predict）” 标签页来预测解释变量取不同值时的概率（这是逻辑回归模型的常见用途）。首先，通过  “预测输入类型（Prediction input type）”  下拉菜单选择预测输入类型，可选择现有数据集（“Data”）或指定命令（“Command”）生成预测输入。如果选择输入命令，必须在  “预测命令（Prediction command）”  框中至少指定一个变量和一个值才能获得预测结果。如果未为模型中的每个变量指定值，则会使用均值或最频繁的水平。只能基于模型中使用的变量预测结果（例如，要预测 90 岁乘客的生存概率，`age`必须是所选解释变量之一）。

要查看生存概率如何随乘客等级变化，请在 “预测” 标签页的 “预测输入类型” 下拉菜单中选择 “Command”，在 “预测命令” 框中输入`pclass = levels(pclass)`，然后按回车。

<p align="center"><img src="figures_model/logistic_predict.png"></p>

上图显示，与一等舱乘客相比，二等舱和三等舱乘客的生存概率大幅下降。对于平均年龄（样本中约 30 岁）的男性，生存概率接近 50%；而对于 30 岁、男性、三等舱乘客，这一概率接近 9%。

```r
    age  sex pclass  pred
 29.881 male    1st 0.499
 29.881 male    2nd 0.217
 29.881 male    3rd 0.092
```

要查看性别的影响，在 “预测命令” 框中输入`sex = levels(sex)`并按回车。对于平均年龄的三等舱女性，生存概率约为 50%；而具有相同年龄和等级特征的男性，生存概率接近 9%。

```r
    age pclass    sex  pred
 29.881    3rd female 0.551
 29.881    3rd   male 0.092
```

要查看年龄的影响，在 “预测命令” 框中输入`age = seq(0, 100, 20)`并按回车。对于三等舱的男婴，生存概率约为 22%；对于 60 岁的三等舱男性，这一概率降至约 3.5%；对于船上年龄最大的男性，模型预测的生存概率接近 1%。

```r
 pclass  sex age  pred
    3rd male   0 0.220
    3rd male  20 0.124
    3rd male  40 0.067
    3rd male  60 0.035
    3rd male  80 0.018
    3rd male 100 0.009
```

要更全面地了解性别、年龄和乘客等级对生存概率的影响，可在 “预测” 标签页的 “预测输入” 下拉菜单中选择 “Data”，并从 “预测数据（Prediction data）” 下拉菜单中选择`titanic`，生成完整的概率表。表格形式的大量数据难以直观解释，但下图清晰展示了生存概率如何随`age`、`gender`和`pclass`变化：

<p align="center"><img src="figures_model/logistic_predict_data.png"></p>

你也可以在 “数据> 转换” 中使用 “扩展网格（Expand grid）” 创建输入数据集，或在电子表格中创建后通过 “数据 > 管理” 标签页粘贴到 Radiant 中。你还可以加载 csv 数据作为输入。例如，将以下链接`https://radiant-rstats.github.io/docs/examples/glm_pred.csv`粘贴到 Radiant 的 “数据> 管理” 标签页中，尝试生成相同的预测。提示：使用 “csv (url)” 加载上述数据链接。

生成所需预测后，可通过点击屏幕右上角的下载图标将其保存为 CSV 文件。要将预测结果添加到用于估计的数据集，点击 “存储（Store）” 按钮。

### 示例 2：DVD 销售情况

我们使用数据集`dvd.rds`，可从<a href="https://radiant-rstats.github.io/docs/examples/dvd.rds"  target="_blank">GitHub</a>下载。该数据包含 20,000 名收到 “即时优惠券”  的客户样本信息。优惠券面值在 1 美元到 5 美元之间变化，并随机分配给选定客户。我们可以使用逻辑回归估计优惠券对新发行 DVD  购买行为的影响。数据中用变量`buy`标识收到优惠券并购买 DVD 的客户（`buy` = `yes`表示客户购买了 DVD，`buy` = `no`表示未购买）。由于我们要预测的变量是二元的，逻辑回归是合适的选择。

为简化示例，我们仅使用客户收到的优惠券面值信息。因此，`buy`是响应变量，`coupon`是解释（或预测）变量。

<p align="center"><img src="figures_model/logistic_dvd.png"></p>

回归输出显示，优惠券面值是客户购买行为的显著预测因子。逻辑回归的系数为 0.701，优势比等于 2.015（即e0.701）。由于优势比大于 1，较高的优惠券面值与较高的购买优势相关。此外，由于系数的 p 值小于 0.05，我们得出结论：（1）系数在统计上显著异于  0；（2）优势比在统计上显著异于 1。优势比为 1 相当于线性回归中的系数估计为 0，意味着解释（或预测）变量对响应变量无影响。估计的优势比  2.015 表明，优惠券面值每增加 1 美元，购买优势增加 101.6%。

### 报告 > Rmd

通过点击屏幕左下角的<i title="report results" class="fa fa-edit"></i>图标或按键盘上的`ALT-enter`，向<a href="https://radiant-rstats.github.io/docs/data/report_rmd.html" target="_blank">*报告 > Rmd*</a>添加代码以（重新）创建分析。

如果已创建图表，可使用`ggplot2`命令或`gridExtra`进行自定义。详见下方示例和<a href="https://radiant-rstats.github.io/docs/data/visualize.html" target="_blank">*数据 > 可视化*</a>。

```r
plot(result, plots = "coef", custom = TRUE) +
  labs(title = "Coefficient plot")
```

### R 函数

有关 Radiant 中用于估计逻辑回归模型的相关 R 函数概述，请参见<a href =  "https://radiant-rstats.github.io/radiant.model/reference/index.html#section-model-logistic-regression" target="_blank">*模型 > 逻辑回归*</a>。
