> 数据中变量的相关性如何？

创建所选变量的相关矩阵。为每个变量对提供相关性和 p 值。要仅显示高于特定（绝对）水平的相关性，使用相关性截断框。

注意：相关性可基于`numeric`、`integer`、`date`和`factor`类型的变量计算。当纳入因子型变量时，应勾选 “调整因子型变量（Adjust for {factor} variables）” 框。进行调整后估计相关性时，因子型变量将被视为（有序）分类变量，其他所有变量将被视为连续变量。

<p align="center"><img src="figures_basics/correlation_summary.png"></p>

“绘图（Plot）” 标签页提供相关矩阵的可视化表示。注意，图表中的散点图默认最多显示 1000 个数据点。要生成使用所有观测值的散点图，在 “报告 > Rmd” 中使用`plot(result, n = -1)`。

“绘图” 标签页中显示的星号含义如下：

- p 值在 0 到 0.001 之间：***
- p 值在 0.001 到 0.01 之间：**
- p 值在 0.01 到 0.05 之间：*
- p 值在 0.05 到 0.1 之间：.

<p align="center"><img src="figures_basics/correlation_plot.png"></p>

图中使用的字体大小与两个变量间相关性的大小和显著性成正比。

### 方法）

选择用于计算相关性的方法。最常用的方法是`Pearson`（皮尔逊）。详见<a  href="https://en.wikipedia.org/wiki/Pearson_product-moment_correlation_coefficient" target = "_blank">维基百科</a>。

### 相关性截断

要仅显示高于特定值的相关性，在 0 到 1 之间的数值输入框中选择非零值（例如 0.15）。

### 协方差矩阵

尽管我们通常使用相关矩阵，但也可通过勾选 “显示协方差矩阵（Show covariance matrix）” 框显示协方差矩阵。

## 存储为数据框

可通过（1）为新数据集提供名称和（2）点击 “存储（Store）” 按钮，将相关矩阵存储为数据框。新数据集将包含每个变量对的估计`correlation`（相关性）和`distance`（距离）度量，距离度量计算如下：`distance = 0.5 * (1 - correlation)`。当两个变量的相关性等于 - 1 时，该度量为 1；当两个变量的相关性等于 1 时，该度量为 0。关于此类数据集的示例，见下方 “数据> 查看”  标签页的截图。此结构的数据集可作为输入，通过 “多元分析 >（不）相似性分析” 创建基于（不）相似性的感知图。

<p align="center"><img src="figures_basics/correlation_store.png"></p>

### Khan 讲解相关性

<p align="center"><iframe width="640" height="375" src="https://www.youtube.com/embed/-Y-M9aD_ccQ" frameborder="0" allowfullscreen></iframe></p>

### 报告 > Rmd

通过点击屏幕左下角的<i title="report results" class="fa fa-edit"></i>图标或按键盘上的`ALT-enter`，向<a href="https://radiant-rstats.github.io/docs/data/report_rmd.html" target="_blank">*报告 > Rmd*</a>添加代码以（重新）创建分析。

默认情况下，相关性图抽样 1000 个数据点。要包含所有数据点，使用`plot(result, n = -1)`。例如，要为图表添加标题，使用`title(main = "相关性图\n\n")`。更多信息见<a  href="https://cran.r-project.org/doc/manuals/R-intro.html#Low_002dlevel-plotting-commands" target="_blank">R 图形</a>文档。

### R 函数

有关 Radiant 中用于评估相关性的相关 R 函数概述，请参见<a href =  "https://radiant-rstats.github.io/radiant.basics/reference/index.html#section-basics-tables" target="_blank">*基础 > 表格*</a>。

`correlation`工具中使用的来自`psych`包的核心函数是`corr.test`。
