> 在不显著丢失信息的情况下降低数据维度

正如因子分析前置分析的文档中所述（见 “多元分析> 因子分析 >  预因子分析”），因子分析的目标是在不显著丢失信息的情况下降低数据维度。该工具通过寻找纳入分析的变量相关矩阵中的结构来实现这一目标。研究者通常会尝试将原始变量（或条目）与潜在因子关联，并为每个因子提供描述性标签。

### 示例：牙膏数据

首先，前往 “数据> 管理” 标签页，从 “加载数据类型（Load data of type）” 下拉菜单中选择**examples**，然后点击 “加载（Load）” 按钮。接着选择`toothpaste`数据集。该数据集包含 60 名消费者的信息，这些消费者被要求回答 6 个问题以确定他们对牙膏的态度。变量 v1-v6 所示的分数表示对陈述的同意程度，采用 7 分制，其中 1 = 强烈不同意，7 = 强烈同意。

确定要提取的因子数量后，我们可以对其进行旋转。因子旋转的目的是生成一种解决方案，在可能的情况下，使一个变量仅在一个因子上有高载荷。这是一个重要的优势，因为它使因子的解释更简单。虽然有多种算法可用于旋转因子载荷矩阵，但最常用的是最大方差旋转（Varimax rotation）。

要复现下方截图中的结果，请确保已加载`toothpaste`数据。然后选择变量`v1`至`v6`，将 “因子数量（Nr. of factors）” 设置为 2，点击 “估计（Estimate）” 按钮或按`CTRL-enter`（Mac 上为`CMD-enter`）生成结果。

<p align="center"><img src="figures_multivariate/full_factor_summary.png"></p>

“因子载荷（Factor loadings）” 表中的数值是 6 个变量与两个因子的相关系数。例如，变量`v1`与因子 1 的相关系数为 0.96，与因子 2 的相关系数为 - 0.03。因此，`v1`在因子 1 的命名中起重要作用，而在因子 2 的命名中作用不显著。

旋转后的因子载荷可用于确定不同因子的标签或名称。我们需要识别并突出显示每行中绝对值最大的因子载荷。通过将 “截断值（Cut-off）” 设置为 0.4 并勾选 “排序因子载荷（Sort factor loadings）” 框，可轻松实现这一点。输出如下：

```r
Loadings:
     RC1   RC2
v1  0.96
v5 -0.93
v3  0.93
v6        0.88
v4        0.85
v2        0.85
```

每列（即每个因子）中显示的变量共同帮助我们理解因子的含义。问题 1、3 和 5 反映了健康问题的重要性，而问题 2、4 和 6 反映了美观问题（见 “数据> 管理” 标签页中的数据描述以了解变量详情）。因此，因子的合理名称可能是：

* **因子 1：** 健康益处
* **因子 2：** 社交益处

了解旋转作用的最佳方式是在 “旋转（Rotation）” 下拉菜单中切换 “最大方差旋转（Varimax）” 和 “无（None）”，并在点击  “估计模型（Estimate model）” 按钮后检查输出的变化。从 “旋转” 下拉菜单中选择 “无”，切换到 “绘图（Plot）”  标签页，点击 “估计模型” 按钮查看更新后的结果。下方左侧图像展示了变量在两个因子上的载荷。变量`v5`在因子 1 和因子 2 的轴之间。然而，当我们选择 “最大方差旋转” 时，`v5`的标签与水平轴（即因子 2）很好地对齐。这种对齐变化也反映在因子载荷中。`v5`的未旋转因子载荷在因子 1 上为 - 0.87，在因子 2 上为 - 0.35；旋转后的因子载荷在因子 1 上为 - 0.93，在因子 2 上为 - 0.08。

<p align="center"><img src="figures_multivariate/full_factor_plot.png"> <img src="figures_multivariate/full_factor_plot_rotation.png"></p>

最后一步是生成因子得分。可以将这些得分视为与某个因子相关联的变量的加权平均值。它们近似于如果我们能通过单个问题询问因子时受访者会给出的得分，即受访者在因子上的推断评分。点击 “存储（Store）” 按钮后，牙膏数据文件中将添加两个新变量（即 factor1 和 factor2）。通过前往 “数据 > 查看”  标签页可以看到它们。我们可以在其他分析中使用因子得分（例如聚类分析或回归分析）。通过在 “数据 > 转换” 标签页中从  “转换类型（Transformation type）” 下拉菜单中选择 “重命名（Rename）”，可以将新变量重命名为`health`和`social`等。

要将因子载荷下载为 csv 文件，点击屏幕右上角的下载按钮。

### 总结

1. 使用巴特利特检验、KMO 检验和共线性分析确定数据是否适合因子分析（“多元分析> 因子分析 > 因子分析前置”）
2. 使用碎石图和特征值大于 1 准则确定要提取的因子数量（“多元分析> 因子分析 > 因子分析前置”）
3. 提取（旋转后的）因子解决方案，生成：
   - 因子载荷：属性与因子之间的相关系数
   - 因子得分：新因子上的推断评分（即汇总原始变量的新变量）
4. 识别每行（即每个变量）中绝对值最大的因子载荷
5. 使用最强的因子载荷为因子命名

如果想进一步练习，请打开`shopping`数据集，尝试复现下方 “摘要（Summary）” 标签页截图中的结果。使用 “多元分析 > 因子分析 > 预因子分析” 确定所选因子数量是否正确。你同意这个结果吗？为什么（不）？

<p align="center"><img src="figures_multivariate/full_factor_summary_shopping.png"></p>

## I纳入分类变量

“多元分析> 因子分析” 中显示的输出通过主成分分析（PCA）或最大似然法（ML）估计。用于估计的相关矩阵可基于`numeric`、`integer`、`date`和`factor`类型的变量计算。当纳入因子型变量时，应勾选 “调整因子型变量（Adjust for {factor} variables）” 框。进行调整后估计相关系数时，因子型变量将被视为（有序）分类变量，其他所有变量将被视为连续变量。

需要注意的是，如果混合使用因子型和数值型变量，估计的因子得分会存在偏差。如果想将因子得分用作进一步分析（如聚类）的输入，应使用（1）全部因子型变量或（2）全部数值型变量，以避免这种偏差。

### 报告 > Rmd

通过点击屏幕左下角的<i title="report results" class="fa fa-edit"></i>图标或按键盘上的`ALT-enter`，向<a href="https://radiant-rstats.github.io/docs/data/report_rmd.html" target="_blank">*报告 > Rmd*</a>添加代码以（重新）创建分析。

如果已创建图表，可使用`ggplot2`命令或`patchwork`进行自定义。详见下方示例和<a href="https://radiant-rstats.github.io/docs/data/visualize.html" target="_blank">*数据 > 可视化*</a>。

```r
plot(result, custom = TRUE) %>%
  wrap_plots(plot_list, ncol = 2) + plot_annotation(title = "Factor Analysis")
```

### R 函数

有关 Radiant 中用于进行因子分析的相关 R 函数概述，请参见<a href =  "https://radiant-rstats.github.io/radiant.multivariate/reference/index.html#section-multivariate-factor" target="_blank">*多元分析 > 因子分析*</a>。

`full_factor`工具中使用的来自`psych`包的核心函数是`principal`和`fa`。
