> 确定合适的细分数量

聚类分析的目标是根据需求、利益和 / 或行为将受访者（如消费者）分组为细分群体。该工具通过寻找相似的受访者，将他们归为一个聚类或细分群体，并将他们与其他不相似的受访者区分开来，以实现这一目标。研究者会比较这些细分群体，并为每个群体提供描述性标签。

### 示例：牙膏数据

首先，前往 “数据> 管理” 标签页，从 “加载数据类型（Load data of type）” 下拉菜单中选择**examples**，然后点击 “加载（Load）” 按钮。接着选择`toothpaste`数据集。该数据集包含 60 名消费者的信息，这些消费者被要求回答 6 个问题以确定他们对牙膏的态度。变量 v1-v6 所示的分数表示对陈述的同意程度，采用 7 分制，其中 1 = 强烈不同意，7 = 强烈同意。

我们首先使用层次聚类分析确定数据中的细分 / 聚类数量。沃德法（Ward’s method）与平方欧氏距离（Squared Euclidean  distance）常被用于衡量个体间的（不）相似程度。这些是 Radiant  中的默认值，但如有需要可以更改。该分析中最重要的信息由图表提供，因此我们将重点关注图表。

在 “变量（Variables）” 框中选择变量 v1 至 v6，点击 “估计（Estimate）” 按钮或按`CTRL-enter`（Mac 上为`CMD-enter`）生成结果。注意，对于大型数据集，层次聚类分析可能耗时且占用大量内存。如果你的数据集有超过 5000 个观测值，请确保将 “最大案例数（Max cases）”  输入框中的值增加到适当数量。下方所示的树状图（Dendrogram）提供了帮助确定最合适聚类（或细分）数量的信息。

层次聚类分析从多个细分群体开始（数量与受访者数量相同），并通过逐步（即层次化）过程将最相似的受访者或群体合并，直到只剩下一个细分群体。要确定合适的细分数量，需寻找图表纵轴上的  “跳跃”。此时，两个不相似的细分群体被合并。纵轴上的度量表示已形成的细分群体内部的异质性水平。聚类的目的是创建同质群体，避免出现具有异质特征、需求等的细分群体。由于异质性最明显的 “跳跃” 出现在从 3 个细分群体合并为 2 个细分群体时，因此我们选择 3 个细分群体（即避免创建异质细分群体）。

<p align="center"><img src="figures_multivariate/hclus_dendro.png"></p>

另一个可用于确定细分数量的图表是碎石图（scree-plot）。该图的纵轴为集群内异质性，横轴为细分群体数量。同样，层次聚类分析从多个细分群体开始，将受访者逐步合并，直到只剩下一个细分群体。通过从 “图表（Plot (s)）” 下拉菜单中选择 “碎石图（Scree）”（和 “变化（Change）”）生成碎石图。如果 “图表截断值（Plot cutoff）” 设为 0，我们会看到所有可能聚类解决方案的结果。为便于评估图表，我们可以将 “图表截断值” 设为例如 0.05（即仅显示  “集群内异质性” 高于 5% 的解决方案）。

<p align="center"><img src="figures_multivariate/hclus_scree.png"></p>

从左到右查看图表，我们发现当从 3 个细分群体变为 2 个细分群体时，群体内异质性急剧增加。这从 “集群内异质性变化（Change in within-cluster  heterogeneity）” 图表（即 “变化（Change）”）中也能清晰看出。为避免创建异质细分群体，我们再次选择 3  个细分群体。确定了要提取的合适细分数量后，我们可以使用 “聚类 > 层次聚类（Cluster > Hierarchical）” 或  “聚类 > K 聚类（Cluster > K-clustering）” 生成最终的聚类解决方案。

要下载图表，点击屏幕右上角的下载按钮。

## 额外选项

* 默认情况下，数据在分析前会进行标准化。要将原始数据传入估计算法，请确保取消勾选 “标准化（Standardize）” 框。
* 层次聚类分析（HC）会生成多个聚类解决方案。最大聚类数量等于数据中的观测值数量（例如，每个受访者都被视为一个单独的聚类）。评估的最小聚类数量为 1（例如，所有受访者被归为一个聚类）。尽管层次聚类分析通常作为诊断工具，用于在使用例如 K  均值法生成最终解决方案之前进行分析，但我们也可以存储使用层次聚类生成的任何特定聚类解决方案。为此，首先选择 “聚类数量（Number of  clusters）”，然后为包含聚类分配信息的变量提供名称，最后点击 “存储（Store）” 按钮。
* 如果用于聚类的数据包含 “因子（factor）” 类型的变量，将自动选择 “高维尔距离（gower  distance）”。有关高维尔距离和相关 R 包的更多信息，请参见<a  href="https://cran.r-project.org/web/packages/gower/vignettes/intro.pdf" target="_blank">包说明文档</a>。

### 报告 > Rmd

通过点击屏幕左下角的<i title="report results" class="fa fa-edit"></i>图标或按键盘上的`ALT-enter`，向<a href="https://radiant-rstats.github.io/docs/data/report_rmd.html" target="_blank">*报告 > Rmd*</a>添加代码以（重新）创建分析。

如果已创建图表，可使用`ggplot2`命令或`gridExtra`进行自定义。详见下方示例和<a href="https://radiant-rstats.github.io/docs/data/visualize.html" target="_blank">*数据 > 可视化*</a>。

```r
plot(result, plots = "change", custom = TRUE) + 
  labs(caption = "Data used from ...")
```

例如，要为树状图添加副标题，使用`title(sub = "数据来源：...")`。更多信息请参见<a  href="https://cran.r-project.org/doc/manuals/R-intro.html#Low_002dlevel-plotting-commands" target="_blank">R 图形</a>文档。

### R 函数

有关 Radiant 中用于进行聚类分析的相关 R 函数概述，请参见<a href =  "https://radiant-rstats.github.io/radiant.multivariate/reference/index.html#section-multivariate-cluster" target="_blank">*多元分析 > 聚类分析*</a>。

`hclus`工具中使用的来自`stats`包的核心函数是`hclust`。
