## urls for menu
r_url_list <- getOption("radiant.url.list")
r_url_list[["Generate descriptive statistics with one click"]] <- "quickgen/basic/"
r_url_list[["AI chat guidance"]] <- "quickgen/chat/"
r_url_list[["AI generates descriptive statistics(chart)"]] <- "quickgen/chart"
options(radiant.url.list = r_url_list)
rm(r_url_list)

## quickgen menu
options(
  radiant.quickgen_ui =
    tagList(
      navbarMenu(
        i18n$t("Oneclick generation"),
        tags$head(
          tags$script(src = "www_quickgen/js/run_return.js")
        ),
        "----", i18n$t("Quick Statistics"),
        tabPanel(i18n$t("Generate descriptive statistics with one click"), uiOutput("quickgen_basic")),
        "----", i18n$t("AI assistance"),
        tabPanel(i18n$t("AI chat guidance"), uiOutput("quickgen_chat")),
        tabPanel(i18n$t("AI generates descriptive statistics(chart)"), uiOutput("quickgen_chart")),
        tabPanel(i18n$t("AI generates descriptive statistics(metrics)"), uiOutput("quickgen_metrics")),
      )
    )
)