% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conjoint.R
\name{conjoint}
\alias{conjoint}
\title{Conjoint analysis}
\usage{
conjoint(
  dataset,
  rvar,
  evar,
  int = "",
  by = "none",
  reverse = FALSE,
  data_filter = "",
  envir = parent.frame()
)
}
\arguments{
\item{dataset}{Dataset}

\item{rvar}{The response variable (e.g., profile ratings)}

\item{evar}{Explanatory variables in the regression}

\item{int}{Interaction terms to include in the model}

\item{by}{Variable to group data by before analysis (e.g., a respondent id)}

\item{reverse}{Reverse the values of the response variable (`rvar`)}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}

\item{envir}{Environment to extract data from}
}
\value{
A list with all variables defined in the function as an object of class conjoint
}
\description{
Conjoint analysis
}
\details{
See \url{https://radiant-rstats.github.io/docs/multivariate/conjoint.html} for an example in Radiant
}
\examples{
conjoint(mp3, rvar = "Rating", evar = "Memory:Shape") \%>\% str()

}
\seealso{
\code{\link{summary.conjoint}} to summarize results

\code{\link{plot.conjoint}} to plot results
}
