> 估计用于分类的多项式逻辑回归（MNL）

### 功能说明

要估计多项逻辑回归（MNL）模型，我们需要一个具有两个或多个水平的分类响应变量，以及一个或多个解释变量。我们还需要指定响应变量中用作比较基准的水平。在示例数据集`ketchup`中，我们可以通过在 “摘要（Summary）” 标签页的 “选择水平（Choose level）” 下拉菜单中选择`heinz28`，将其设为基准水平。

要获取`ketchup`数据集，请前往 “数据> 管理”，从 “加载数据类型（Load data of type）” 下拉菜单中选择`examples`，点击 “加载（Load）” 按钮，然后选择`ketchup`数据集。

在 “摘要” 标签页中，我们可以通过在 “待检验变量（Variables to test）” 下拉菜单中选择变量，检验两个或多个变量是否共同改善模型拟合。此功能对于评估具有三个或更多水平的因子（factor）类型变量的整体影响非常有用。

需要重新估计的额外输出：

* 标准化（Standardize）：如果解释变量的测量尺度不同，相对风险比（RRRs）可能难以比较。通过在估计前对解释变量进行标准化，我们可以看出哪些变量的影响更大。Radiant 中对多项逻辑回归数据的标准化方法是将所有解释变量X替换为(X−mean(X))/(2×sd(X))。详见<a  href="http://www.stat.columbia.edu/~gelman/research/published/standardizing7.pdf" target="_blank">Gelman 2008</a>的讨论。
* 中心化（Center）：将所有解释变量X替换为X−mean(X)。这在解释交互效应时可能有用。
* 逐步回归（Stepwise）：一种数据挖掘方法，用于选择拟合效果最佳的模型。使用时需谨慎！

无需重新估计的额外输出：

- 置信区间（Confidence intervals）：系数的置信区间。
- 相对风险比（RRRs）：带置信区间的相对风险比。
- 混淆矩阵（Confusion）：展示（1）数据中观察到的实际类别与（2）模型预测的最可能类别之间一致性（或不一致性）的混淆矩阵。

### 示例：番茄酱选择行为

我们以美国密苏里州斯普林菲尔德市一个家庭面板中 300 名个体的选择行为数据集为例。该数据记录了约 2 年时间内 2798 次购买场景的信息，包含以下变量：

* `id`：个体标识
* `choice`：选择结果，取值为 heinz41、heinz32、heinz28、hunts32 中的一种
* `price.x`：产品 x 的价格
* `disp.x`：产品 x 是否有陈列（是或否）
* `feat.x`：产品 x 是否有报纸特色广告（是或否）

下方 “数据> 透视表” 标签页的截图显示，`heinz32`是最受欢迎的选择，其次是`heinz28`。`heinz41`和`hunts32`在家庭面板成员中的选择频率低得多。

<p align="center"><img src="figures_model/mnl_choice_shares.png"></p>

假设我们想研究不同产品的价格如何影响番茄酱品牌和包装规格的选择。在 “模型> 多项逻辑回归（MNL） > 摘要” 标签页中，选择`choice`作为响应变量，并从 “选择基准水平（Choose base level）” 下拉菜单中选择`heinz28`。选择`price.heinz28`至`price.hunts32`作为解释变量。在下方截图中，我们看到大多数（但并非全部）系数的 p 值非常小，且模型具有一定的预测能力（卡方统计量的 p 值 < 0.001）。最左侧的输出列显示系数对应的产品。例如，系数和统计量的第二行反映了`price.heinz28`的变化对选择`heinz32`相对于基准产品（即`heinz28`）的影响。如果消费者将`heinz28`和`heinz32`视为替代品（这很可能），我们预期`price.heinz28`上涨会导致消费者选择`heinz32`而非`heinz28`的优势增加。

遗憾的是，多项逻辑回归模型的系数难以直接解释。但 “RRR” 列提供了相对风险比（或优势比）的估计值，更便于分析。`RRR`值是回归系数的指数化结果（即exp(1.099)=3.000）。我们发现，在模型中其他变量保持不变的情况下，`price.heinz28`每上涨 1 美元，购买`heinz32`而非`heinz28`的 “风险”（或优势）变为原来的 3 倍。

<p align="center"><img src="figures_model/mnl_summary.png"></p>

对于每个解释变量，可提出以下原假设和备择假设：

- H0：解释变量 x 相关的相对风险比等于 1
- Ha：解释变量 x 相关的相对风险比不等于 1

多项逻辑回归中部分相对风险比的解释如下：

```r
                         RRR coefficient std.error z.value p.value    
 heinz32 price.heinz32 0.101      -2.296     0.135 -17.033  < .001 ***
 hunts32 price.heinz28 3.602       1.282     0.126  10.200  < .001 ***
 hunts32 price.hunts32 0.070      -2.655     0.208 -12.789  < .001 ***
```

- `price.heinz32`每上涨 1 美元，选择`heinz32`而非`heinz28`的相对优势比为 0.101。即当`heinz32`价格上涨 1 美元时，在模型中其他变量保持不变的情况下，选择`heinz32`而非`heinz28`的优势变为原来的 0.101 倍，或下降 89.9%。
- `price.heinz28`每上涨 1 美元，选择`hunts32`而非`heinz28`的相对优势比为 3.602。即当`heinz28`价格上涨 1 美元时，在模型中其他变量保持不变的情况下，选择`hunts32`而非`heinz28`的优势变为原来的 3.602 倍，或增加 260.2%。
- `price.hunts32`每上涨 1 美元，选择`hunts32`而非`heinz28`的相对优势比为 0.070。即当`hunts32`价格上涨 1 美元时，在模型中其他变量保持不变的情况下，选择`hunts32`而非`heinz28`的优势变为原来的 0.070 倍，或下降 93%。

模型中估计的其他`RRRs`可按类似方式解释。

除了 “摘要” 标签页中的数值输出外，我们还可以可视化评估选择结果（`choice`）与四种产品价格之间的关系（见 “绘图（Plot）” 标签页）。在下方截图中，我们看到带有置信区间的系数（更准确地说是 RRR）图。我们观察到以下模式：

- 当`price.heinz28`上涨 1 美元时，选择`heinz32`、`heinz41`和`hunts32`的相对优势显著增加
- 当`price.heinz32`上涨时，选择`heinz32`而非`heinz28`的优势显著下降。当`heinz41`和`hunts32`的价格上涨时，我们也观察到相同模式
- `hunts32`是唯一一种在`price.heinz32`上涨时，相对于`heinz28`的购买优势显著提升的产品

<p align="center"><img src="figures_model/mnl_plot.png"></p>

概率通常比多项逻辑回归模型的系数或相对风险比更便于解释。我们可以使用 “预测（Predict）”  标签页，在给定所选解释变量特定值的情况下，预测响应变量每个水平的概率。首先，通过 “预测输入类型（Prediction input type）” 下拉菜单选择预测输入类型，可选择现有数据集（“Data”）或指定命令（“Command”）生成预测输入。如果选择输入命令，必须在  “预测命令（Prediction command）”  框中至少指定一个变量和一个值才能获得预测结果。如果未为模型中的每个变量指定值，则会使用均值或最频繁出现的水平。只能基于模型中使用的变量预测概率。例如，要预测`heinz32`定价为 3.80 美元时的选择概率，`price.heinz32`必须是所选解释变量之一。

* 要预测商店中`hunts32`有陈列时四种产品的选择概率，在命令框中输入`disp.hunts32 = "yes"`并按回车
* 要预测`heinz41`有无陈列和有无特色广告时的选择概率，输入`disp.heinz41 = c("yes", "no"), feat.heinz41 = c("yes", "no")`并按回车
* 要查看随着`price.heinz28`上涨，每种产品的选择概率如何变化，输入`price.heinz28 = seq(3.40, 5.20, 0.1)`并按回车。见下方截图。

<p align="center"><img src="figures_model/mnl_predict.png"></p>

上图显示，随着`price.heinz28`上涨，`heinz28`的购买概率大幅下降。数据中最受欢迎的`heinz32`，在`price.heinz28`上涨后，其预测购买概率大幅增加。尽管图表中`hunts32`的预测购买概率增幅看似不如`heinz32`显著，但相对增幅更大（即`hunts32`从 3.2% 增至 8.4%，而`heinz32`从 39.3% 增至 72.8%）。

要更全面地评估四种产品的价格变化对购买概率的影响，可在 “预测” 标签页的 “预测输入类型” 下拉菜单中选择 “Data”，并从 “预测数据（Predict data）” 下拉菜单中选择`ketchup`，生成完整的预测表。你也可以在 “数据> 转换” 中使用 “扩展网格（Expand grid）” 创建输入数据集，或在电子表格中创建后通过 “数据 > 管理” 标签页粘贴到 Radiant 中。

生成所需预测后，可通过点击预测表右上角的下载图标将其保存为 CSV 文件。要将预测结果添加到用于估计的数据集，点击 “存储（Store）” 按钮。

注意，MNL 模型生成的概率列数与分类响应变量的水平数相同（即番茄酱数据中有 4 列）。如果只想将第一水平（即`heinz28`）的预测结果添加到用于估计的数据集，在 “存储预测（Store predictions）” 输入框中仅提供一个名称即可。如果想存储所有番茄酱产品的预测结果，输入四个变量名，用逗号分隔。

> 注意：在上述讨论中，我们忽略了<a href="https://en.wikipedia.org/wiki/Endogeneity_(econometrics)" target="blank">内生性问题</a>。例如，假设`price.heinz28`的变化源于`heinz28`质量的变化，质量变化会影响价格，也可能影响产品需求。除非我们以某种方式控制质量变化，否则价格变化的估计效应很可能不准确（即存在偏差）。

### 报告 > Rmd

通过点击屏幕左下角的<i title="report results" class="fa fa-edit"></i>图标或按键盘上的`ALT-enter`，向<a href="https://radiant-rstats.github.io/docs/data/report_rmd.html" target="_blank">*报告 > Rmd*</a>添加代码以（重新）创建分析。

如果已创建图表，可使用`ggplot2`命令或`gridExtra`进行自定义。详见下方示例和<a href="https://radiant-rstats.github.io/docs/data/visualize.html" target="_blank">*数据 > 可视化*</a>。

```r
plot(result, plots = "coef", custom = TRUE) +
  labs(title = "Coefficient plot")
```

### R 函数

有关 Radiant 中用于估计多项逻辑回归模型的相关 R 函数概述，请参见<a href =  "https://radiant-rstats.github.io/radiant.model/reference/index.html#section-model-multinomial-logistic-regression" target="_blank">*模型 > 多项式逻辑回归*</a>。

`mnl`工具中使用的核心函数包括`nnet`包中的`multinom`和`car`包中的`linearHypothesis`。
