% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hclus.R
\name{store.hclus}
\alias{store.hclus}
\title{Add a cluster membership variable to the active dataset}
\usage{
\method{store}{hclus}(dataset, object, nr_clus = 2, name = "", ...)
}
\arguments{
\item{dataset}{Dataset to append to cluster membership variable to}

\item{object}{Return value from \code{\link{hclus}}}

\item{nr_clus}{Number of clusters to extract}

\item{name}{Name of cluster membership variable}

\item{...}{Additional arguments}
}
\description{
Add a cluster membership variable to the active dataset
}
\details{
See \url{https://radiant-rstats.github.io/docs/multivariate/hclus.html} for an example in Radiant
}
\examples{
hclus(shopping, vars = "v1:v6") \%>\%
  store(shopping, ., nr_clus = 3) \%>\%
  head()
}
\seealso{
\code{\link{hclus}} to generate results

\code{\link{summary.hclus}} to summarize results

\code{\link{plot.hclus}} to plot results
}
