% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prmap.R
\name{prmap}
\alias{prmap}
\title{Attribute based brand maps}
\usage{
prmap(
  dataset,
  brand,
  attr,
  pref = "",
  nr_dim = 2,
  hcor = FALSE,
  data_filter = "",
  envir = parent.frame()
)
}
\arguments{
\item{dataset}{Dataset}

\item{brand}{A character variable with brand names}

\item{attr}{Names of numeric variables}

\item{pref}{Names of numeric brand preference measures}

\item{nr_dim}{Number of dimensions}

\item{hcor}{Use polycor::hetcor to calculate the correlation matrix}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}

\item{envir}{Environment to extract data from}
}
\value{
A list of all variables defined in the function as an object of class prmap
}
\description{
Attribute based brand maps
}
\details{
See \url{https://radiant-rstats.github.io/docs/multivariate/prmap.html} for an example in Radiant
}
\examples{
prmap(computer, brand = "brand", attr = "high_end:business") \%>\% str()

}
\seealso{
\code{\link{summary.prmap}} to summarize results

\code{\link{plot.prmap}} to plot results
}
