## sourcing from radiant.data
options(radiant.path.data = system.file(package = "radiant.data"))
source(file.path(getOption("radiant.path.data"), "app/global.R"), encoding = getOption("radiant.encoding", default = "UTF-8"), local = TRUE)

ifelse(grepl("radiant.quickgen", getwd()) && file.exists("../../inst"), "..", system.file(package = "radiant.quickgen")) %>%
  options(radiant.path.quickgen = .)

## setting path for www resources
addResourcePath("www_quickgen", file.path(getOption("radiant.path.quickgen"), "app/www/"))

## loading urls and ui
source("init.R", encoding = getOption("radiant.encoding", "UTF-8"), local = TRUE)
options(radiant.url.patterns = make_url_patterns())

if (!"package:radiant.quickgen" %in% search() &&
    isTRUE(getOption("radiant.development")) &&
    getOption("radiant.path.quickgen") == "..") {
  options(radiant.from.package = FALSE)
} else {
  options(radiant.from.package = TRUE)
}