> 使用 K 聚类创建细分群体

聚类分析的目标是根据需求、利益和 / 或行为将受访者（如消费者）分组为细分群体。该工具通过寻找相似的受访者，将他们归为一个聚类或细分群体，并将他们与其他不相似的受访者区分开来，以实现这一目标。研究者会比较这些细分群体，并为每个群体提供描述性标签。

### 示例：牙膏数据

首先，前往 “数据> 管理” 标签页，从 “加载数据类型（Load data of type）” 下拉菜单中选择**examples**，然后点击 “加载（Load）” 按钮。接着选择`toothpaste`数据集。该数据集包含 60 名消费者的信息，这些消费者被要求回答 6 个问题以确定他们对牙膏的态度。变量 v1-v6 所示的分数表示对陈述的同意程度，采用 7 分制，其中 1 = 强烈不同意，7 = 强烈同意。

使用层次聚类分析确定要提取的聚类数量后，我们使用 K 聚类创建最终的细分群体。该算法的主要优势是在寻找最合适的受访者分组时具有灵活性和稳健性。对于营销和商业数据，我们通常使用层次聚类分析选择细分群体数量，再用 K 聚类创建最终的细分群体。

要对牙膏数据应用 K 聚类，在算法中选择`K-means`，在 “变量（Variables）” 框中选择变量 v1 至 v6，选择 3 作为聚类数量。由于数据观测值相对较少，我们可以使用层次聚类分析（HC）提供初始聚类中心。更改设置后，点击 “估计（Estimate）” 按钮或按`CTRL-enter`（Mac 上为`CMD-enter`）生成结果。

在 “摘要（Summary）” 标签页中，我们使用 “聚类均值（Cluster means）”  表描述分配到某个细分群体的个体。表中的每个数值表示该细分群体中人们在某个变量上的平均得分。例如，细分群体 3 在问题 v2 上的平均得分为  5.750（满分 7  分）。我们需要寻找极高或极低的均值来帮助区分细分群体，因为我们要确定一个细分群体与其他群体的差异。如果某个变量在不同细分群体中的均值没有显著差异，那么该变量对解释分析结果用处不大。通过突出最能清晰区分不同细分群体的变量，我们可以生成描述每个细分群体中消费者的名称或标签，并说明各细分群体之间的差异。

<p align="center"><img src="figures_multivariate/kclus_summary.png"></p>

通过绘制每个细分群体和变量的数据，可视化细分群体的分离程度会很有帮助。下方所示为密度图。对于变量 v1，聚类分离效果良好。细分群体 2（绿色）对 “购买预防蛀牙的牙膏很重要” 这一问题的平均响应似乎低于细分群体 3（蓝色）和细分群体 1（粉色）。而细分群体 1  在该问题上的得分又高于其他两个细分群体。对于问题 v4，我们看到不同的模式。细分群体 1（绿色）和细分群体 2（粉色）对  “我偏好清新口气的牙膏” 这一问题的平均响应非常相似，图表重叠。而细分群体 3（蓝色）在该问题上的得分高于其他两个细分群体。

<p align="center"><img src="figures_multivariate/kclus_plot.png"></p>

通过查看 “摘要” 标签页中的聚类均值表和 “绘图” 标签页中的密度图，我们可以得出以下标签：细分群体 3 在问题 v2、v4 和 v6  上的得分较高，我们可以称他们为 “美容型刷牙者”；细分群体 1 在问题 v1 和 v3 上的得分较高，在 v5  上的得分较低，他们似乎最关注牙膏的健康益处，因此可以称他们为 “治疗型刷牙者”；细分群体 2 在 v1 和 v3 上的得分较低，在 v5  上的得分较高，即他们不太关注牙膏的健康益处，且在美容益处上的得分处于中等水平，因此可以称他们为 “无特定偏好型刷牙者”。要将聚类均值表保存为  csv 文件，按屏幕右上角的下载按钮。

对细分群体分类后，我们可以通过点击 “存储（Store）”  按钮创建细分群体（或聚类）成员变量。牙膏数据中会添加一个新变量，显示哪些受访者被分配到每个聚类（即聚类成员资格）。我们可以通过 “数据 > 转换” 菜单将创建的聚类变量修改为上述描述性标签。在 “选择列（Select column (s)）” 框中选择`kclus`变量，然后从 “转换类型（Transform type）” 下拉菜单中选择 “重编码（Recode）”。在重编码框中输入（或粘贴）以下命令并按回车：

```r
1 = '治疗型'; 2 = '无特定偏好型'; 3 = '美容型'
```

这应生成下方所示的输出。确认结果符合预期后，点击 “存储（Store）” 按钮将重编码后的变量添加到牙膏数据集。

<p align="center"><img src="figures_multivariate/kclus_transform_recode.png"></p>

我们可以使用交叉表（如性别与细分群体成员资格）结合人口统计数据描述这些细分群体。前往 “基础> 表格 > 交叉表”。我们的原假设和备择假设如下：

```r
H0：性别与细分群体成员资格之间无关联
Ha：性别与细分群体成员资格之间有关联
```

在 “摘要” 标签页中，我们看到这两个变量之间存在显著关联。p 值为 0.001，且没有单元格的预期值低于 5（详见 “基础 > 表格 > 交叉表” 的帮助文件）。

<p align="center"><img src="figures_multivariate/kclus_cross_tabs_summary.png"></p>

要图形化展示这种关联，前往 “绘图（Plot）” 标签页。如果选择 “标准差偏差（Deviation std.）”，我们看到 “无特定偏好型”  细分群体中的男性数量显著多于原假设（无关联）下的预期数量。我们也可以认为 “美容型”  细分群体中的女性数量多于原假设下的预期数量，尽管显著性水平较低（即 < 0.1 但不 <  0.05）。总之，在这些数据中，男性似乎更可能属于 “无特定偏好型刷牙者” 细分群体，而女性似乎（在较低显著性水平上）更可能属于  “美容型刷牙者” 细分群体。

<p align="center"><img src="figures_multivariate/kclus_cross_tabs_plot.png"></p>

## 额外选项

- 默认情况下，数据在分析前会进行标准化。要将原始数据传入估计算法，请确保取消勾选 “标准化（Standardize）” 框。
- 如果用于聚类的数据包含 “因子（factor）” 类型的变量，应使用`K-proto`（K - 原型）算法。如果选择`K-means`，则仅保留数值变量用于分析。有关`kproto`函数和`clustMixType`R 包的更多信息，请参见<a  href="https://journal.r-project.org/archive/2018/RJ-2018-048/RJ-2018-048.pdf" target="_blank">R 期刊文章</a>。

### 报告 > Rmd

通过点击屏幕左下角的<i title="report results" class="fa fa-edit"></i>图标或按键盘上的`ALT-enter`，向<a href="https://radiant-rstats.github.io/docs/data/report_rmd.html" target="_blank">*报告 > Rmd*</a>添加代码以（重新）创建分析。

如果已创建图表，可使用`ggplot2`命令或`patchwork`进行自定义。详见下方示例和<a href="https://radiant-rstats.github.io/docs/data/visualize.html" target="_blank">*数据 > 可视化*</a>。

```r
plot(result, plots = "bar", custom = TRUE) %>%
  wrap_plots(plot_list, ncol = 2) + plot_annotation(title = "K-means Cluster Analysis")
```

### R 函数

有关 Radiant 中用于进行聚类分析的相关 R 函数概述，请参见<a href =  "https://radiant-rstats.github.io/radiant.multivariate/reference/index.html#section-multivariate-cluster" target="_blank">*多元分析 > 聚类分析*</a>。

`kclus`工具中使用的来自`stats`包的核心函数是`kmeans`。
