> 数据和状态管理：将数据加载到 Radiant、将数据保存到磁盘、从内存中移除数据集，或保存 / 加载应用状态

### 数据集

首次启动 Radiant 时，会显示一个包含钻石价格信息的数据集（`diamonds`）。

为你使用的每个文件添加数据和变量描述是良好的实践。对于 Radiant 自带的文件，在数据前 10  行的表格下方，你会看到变量等的简要概述。要为自己的数据添加描述，点击 `添加 / 编辑数据描述`复选框。表格下方会打开一个文本输入框，你可以在其中以<a  href="https://rmarkdown.rstudio.com/authoring_pandoc_markdown.html"  target="_blank">markdown</a>格式添加文本。Radiant 自带的`diamonds`数据的描述应能作为良好示例。添加或编辑描述后，点击 `更新描述` 按钮。

要重命名 Radiant 中已加载的数据集，点击 `重命名数据` 复选框，输入新名称，然后点击 `重命名`按钮。

### 加载数据

在 Radiant（和 R）中加载和保存数据的最佳方式是使用 R 数据格式（rds 或 rda）。这些是二进制文件，可紧凑存储且能快速读入 R。从 `加载数据类型` 下拉菜单中选择`rds`（或`rda`），点击 `浏览` 找到你要在电脑上加载的文件。

有两种方法可将电子表格（如 Excel 或 Google 表格）中的数据导入 Radiant。第一种，你可以将电子表格中的数据保存为 csv 格式，然后在 Radiant 中从`加载数据类型` 下拉菜单中选择`csv`。你的 csv 文件很可能有包含变量名的标题行。如果数据不是用逗号分隔的，你可以选择分号或制表符分隔。要加载 csv 文件，点击 `浏览`  并在电脑上找到该文件。

另外，你可以在电子表格中使用 CTRL-C（或 Mac 上的 CMD-C）选择并复制数据，转到 Radiant，从 `加载数据类型` 下拉菜单中选择`剪贴板`，然后点击 `粘贴` 按钮。对于格式清晰的小型数据集，这是个便捷的捷径。

如果数据在 R 的全局工作区中可用（例如，你在 RStudio 中打开了一个数据集，然后从 “插件（addins）” 菜单启动了  Radiant），你可以通过选择 “from global workspace”（从全局工作区）将其移动（或复制）到  Radiant。选择你要使用的数据框，然后点击 `加载` 按钮。

要访问 Radiant 自带的所有数据文件，从 “加载数据类型” 下拉菜单中选择`examples`（示例），然后点击 “加载” 按钮。这些文件用于演示 Radiant 中各种数据和分析工具。例如，`avengers`和`publishers`数据用于演示如何在 R（adiant）中合并数据（即 “数据> 合并”）。

如果 csv 数据在线可用，从下拉菜单中选择`csv (url)`，将网址粘贴到显示的文本输入框中，然后按 `加载`。如果 rda 文件在线可用，从下拉菜单中选择`rda (url)`，将网址粘贴到文本输入框中，然后按 `加载`。

### 保存数据

如前所述，在 Radiant 中导入和导出数据最便捷的方式是使用 R 数据格式（rds 或 rda）。从 `保存数据类型` 下拉菜单中选择`rds`（或`rda`），点击 `保存` 按钮将所选数据集保存到文件。

同样，为你使用的每个文件添加数据和变量描述是良好的实践。要为自己的数据添加描述，点击 `添加 / 编辑数据描述` 复选框，在文本输入窗口中以<a  href="https://rmarkdown.rstudio.com/authoring_pandoc_markdown.html"  target="_blank">markdown</a>格式添加文本，然后点击 `更新描述` 按钮。当你将数据保存为  `rds`（或` rda`）文件时，你创建（或编辑）的描述会自动作为`attribute`（属性）添加到文件中。

将数据从 Radiant 导入电子表格有两种方法。第一种，你可以将数据保存为 csv 格式，然后将文件加载到电子表格中（即从 “保存数据类型” 下拉菜单中选择`csv`，点击 “保存” 按钮）。另外，你可以通过从下拉菜单中选择`剪贴板`，点击 `复制` 按钮，将数据从 Radiant 复制到剪贴板，打开电子表格，使用 CTRL-V（或 Mac 上的 CMD-V）将 Radiant 中的数据粘贴进去。

要将数据从 Radiant 移动或复制到 R（studio）的全局工作区，从 “保存数据类型” 下拉菜单中选择`到全局工作空间`，点击 `保存` 按钮。

### 保存和加载状态

如果你想在其他时间（可能在另一台电脑上）完成工作，或回顾之前使用 Radiant 完成的工作，使用状态文件会很方便。你可以像保存数据文件一样保存和加载 Radiant 应用的状态。状态文件（扩展名为`.state.rda`）将包含：（1）Radiant 中加载的数据；（2）你正在进行的分析设置；（3）“报告（Report）”  菜单中的所有报告或代码。要将应用的当前状态保存到硬盘，点击导航栏中的<i title='Save' class='fa  fa-save'></i>图标，然后点击 `保存 Radiant 状态文件`。要加载之前的状态，点击导航栏中的<i title='Save' class='fa  fa-save'></i>图标，然后点击`加载 Radiant 状态文件`。

你也可以与想要复现你分析的人共享状态文件。例如，下载然后按上述方法加载状态文件<a  href="https://github.com/radiant-rstats/docs/raw/gh-pages/examples/radiant-example.state.rda" target="_blank">radiant-example.state.rda</a>。你会自动导航到 “数据>  可视化” 标签页并看到一个图表。也可查看 “数据 > 查看”  标签页，获取从状态文件加载的其他设置。“报告 > Rmd” 中还有一个使用 Radiant 界面创建的报告。html 文件<a  href="https://radiant-rstats.github.io/docs/examples/radiant-example.nb.html" target="_blank">radiant-example.nb.html</a>包含点击`编译报告` 按钮生成的输出。

状态的加载和保存也适用于 RStudio。如果你从 RStudio 启动 Radiant，使用<i title='Power off' class='fa fa-power-off'></i>然后点击 `停止`，`r_data`环境以及`r_info`和`r_state`列表会放入 RStudio 的全局工作区。如果你从 “插件（Addins）” 菜单再次启动 Radiant，它会使用`r_data`、`r_info`和`r_state`恢复状态。此外，如果你直接在 RStudio 中加载状态文件，启动 Radiant 时会使用该文件。

使用导航栏中<i title='Power off' class='fa fa-power-off'></i>菜单中的 `刷新` 可返回到干净 / 新状态。

### 从内存中移除数据

如果内存中加载了当前会话不再需要的数据，勾选 `从内存中移除数据`框。然后选择要移除的数据，点击 `移除数据` 按钮。始终会保留一个数据文件。

### 使用命令加载和保存数据

在 “报告> Rmd” 或 “报告 > R” 中，可使用 R 代码将数据从文件直接加载到活跃的 Radiant 会话中。使用`register("insert-dataset-name")`将数据集添加到 “数据集（Datasets）” 下拉菜单中。也可使用 R 代码从 Radiant 提取数据并保存到磁盘。

### R 函数

有关 Radiant 中用于加载和保存数据的相关 R 函数概述，请参见<a href = "  https://radiant-rstats.github.io/radiant.data/reference/index.html#section-data-manage" target="_blank">*数据 > 管理*</a> 。
